/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.validator.intercept;

import cn.vonce.validator.annotation.VBean;
import cn.vonce.validator.config.EnableValidator;
import cn.vonce.validator.config.ResultConfig;
import cn.vonce.validator.enumerate.ResultCode;
import cn.vonce.validator.enumerate.ResultType;
import cn.vonce.validator.exception.ValidatorException;
import cn.vonce.validator.helper.ValidatorHelper;
import cn.vonce.validator.model.BeanResult;
import cn.vonce.validator.model.FieldResult;
import cn.vonce.validator.utils.RequestDataUtil;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ValidatorInterceptor
implements MethodInterceptor {
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public Object invoke(MethodInvocation arg0) throws Throwable {
        String fullName = arg0.getMethod().getReturnType().getSimpleName() + " " + arg0.getThis().getClass().getName() + "." + arg0.getMethod().getName();
        if (fullName.contains("$$")) {
            return arg0.proceed();
        }
        if (arg0.getArguments().length == 0) {
            return arg0.proceed();
        }
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        HttpServletResponse response = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
        BeanResult beanResult = new BeanResult(true, "\u6821\u9a8c\u901a\u8fc7");
        for (int i = 0; i < arg0.getArguments().length; ++i) {
            Object object = arg0.getArguments()[i];
            Annotation[] annotations = arg0.getMethod().getParameterAnnotations()[i];
            VBean validBean = (VBean)ValidatorHelper.getAnnotation((Annotation[])annotations, VBean.class);
            if (validBean != null) {
                beanResult = ValidatorHelper.validBean((Object)object, (String)validBean.group(), (boolean)validBean.interrupt());
                break;
            }
            List validFieldResultList = ValidatorHelper.valid((Annotation[])annotations, (String)(arg0.getMethod().getName() + "\u65b9\u6cd5\u7b2c" + (i + 1) + "\u4e2a\u53c2\u6570"), (Object)object, null, (String)"", (boolean)true);
            if (validFieldResultList.isEmpty()) continue;
            beanResult = new BeanResult("\u6821\u9a8c\u5b58\u5728" + validFieldResultList.size() + "\u6761\u9519\u8bef", validFieldResultList);
            break;
        }
        this.logger.info("\u6b63\u5728\u6821\u9a8c\u53c2\u6570: " + fullName + "[" + request.getRequestURI() + "]");
        this.logger.info("\u8bf7\u6c42URL\u53c2\u6570: " + RequestDataUtil.getParameters((Map)request.getParameterMap()));
        if (!beanResult.isPass()) {
            ResultType resultType;
            String tips = ((FieldResult)beanResult.getFieldResultList().get(0)).getTips();
            this.logger.warning(beanResult.getMessage() + "\uff0c\u8be6\u60c5\u8bf7\u770b: " + beanResult.getFieldResultList());
            this.logger.info("\u53c2\u6570\u6821\u9a8c\u4e0d\u901a\u8fc7: " + fullName);
            EnableValidator enableValidator = arg0.getThis().getClass().getAnnotation(EnableValidator.class);
            if (enableValidator != null) {
                resultType = enableValidator.resultType();
            } else {
                WebApplicationContext webApplicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)request.getServletContext());
                ResultConfig resultConfig = (ResultConfig)webApplicationContext.getBean(ResultConfig.class);
                resultType = resultConfig.getResultType();
            }
            if (resultType == null || resultType == ResultType.THROW_TIPS) {
                throw new ValidatorException("\u53c2\u6570\u6821\u9a8c\u9519\u8bef[" + tips + "]");
            }
            this.defaultResult(tips, request, response);
            return null;
        }
        return arg0.proceed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void defaultResult(String tips, HttpServletRequest request, HttpServletResponse response) {
        try (PrintWriter printWriter = null;){
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/json; charset=utf-8");
            printWriter = response.getWriter();
            String data = "{\"code\":" + ResultCode.BAD.getCode() + ",\"msg\":\"" + tips + "\"}";
            printWriter.write(data);
            this.logger.info(request.getServletPath() + " \u7684\u54cd\u5e94\u5185\u5bb9\uff1a" + data);
        }
    }
}

