/*
 * Decompiled with CFR 0.152.
 */
package cn.vorbote.commons;

import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MathUtil {
    private static final Logger log = LoggerFactory.getLogger(MathUtil.class);

    private MathUtil() {
    }

    public static long Factorial(int n) {
        if (n < 0) {
            throw new RuntimeException("A number lower than 0 has no factorial result");
        }
        if (n <= 1) {
            return 1L;
        }
        return (long)n * MathUtil.Factorial(n - 1);
    }

    public static double Sum(Collection<? extends Number> numbers) {
        double sum = 0.0;
        for (Number number : numbers) {
            sum += number.doubleValue();
        }
        return sum;
    }

    public static double Average(Collection<? extends Number> numbers) {
        double sum = MathUtil.Sum(numbers);
        log.debug("sum = {}, size = {}", (Object)sum, (Object)numbers.size());
        return sum / (double)numbers.size();
    }

    public static boolean IsBetween(Number num, Number noLess, Number noGreater) {
        return num.doubleValue() <= noGreater.doubleValue() && num.doubleValue() >= noLess.doubleValue();
    }
}

