/*
 * Decompiled with CFR 0.152.
 */
package cn.vorbote.commons;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CaseUtil {
    private static final Logger log = LoggerFactory.getLogger(CaseUtil.class);
    private static final Pattern AZ_PATTERN = Pattern.compile("[A-Z]");
    private static final Pattern UNDERLINE_PATTERN = Pattern.compile("_([a-z])");

    private CaseUtil() {
    }

    public static String Underline(String str) {
        log.debug(String.format("Transferring [%s] to Underline Pattern", str));
        Matcher matcher = AZ_PATTERN.matcher(str);
        StringBuilder sb = new StringBuilder(str);
        if (!matcher.find()) {
            return sb.toString();
        }
        sb = new StringBuilder();
        matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        matcher.appendTail(sb);
        return CaseUtil.Underline(sb.toString());
    }

    public static String LowerCamel(String str) {
        log.debug(String.format("Transferring [%s] to LowerCamel Pattern", str));
        Matcher matcher = UNDERLINE_PATTERN.matcher(str);
        StringBuilder sb = new StringBuilder(str);
        if (!matcher.find()) {
            return sb.toString();
        }
        sb = new StringBuilder();
        matcher.appendReplacement(sb, matcher.group(1).toUpperCase());
        matcher.appendTail(sb);
        return CaseUtil.LowerCamel(sb.toString());
    }
}

