/*
 * Decompiled with CFR 0.152.
 */
package cn.vorbote.commons;

import cn.vorbote.commons.StringUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateUtil {
    private static final Logger log = LoggerFactory.getLogger(DateUtil.class);
    private static final String DEFAULT_PATTERN = "yyyy-MM-dd hh:mm:ss";
    public static final String JAVA_TIMESTAMP = "\\d{13}";
    public static final String UNIX_TIMESTAMP = "\\d{10}";

    private DateUtil() {
    }

    public static Date TimestampToDate(String strDate) {
        log.debug(String.format("Transferring [%s] to Date object.", strDate));
        if (strDate.matches(UNIX_TIMESTAMP)) {
            return new Date(Long.parseLong(strDate) * 1000L);
        }
        if (strDate.matches(JAVA_TIMESTAMP)) {
            return new Date(Long.parseLong(strDate));
        }
        return new Date();
    }

    public static String DateToString(Date date, String pattern) {
        if (StringUtil.IsBlank(pattern)) {
            log.debug("Passed a null value of parameter pattern, using the DEFAULT pattern.");
            pattern = DEFAULT_PATTERN;
        }
        log.debug(String.format("Transferring date object to String as the pattern of %s", pattern));
        SimpleDateFormat dateFormatter = new SimpleDateFormat(pattern);
        return dateFormatter.format(date);
    }

    public static Date GetDate(int year, int month, int date) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, date);
        return calendar.getTime();
    }

    public static Date GetDate(Calendar calendar) {
        return calendar.getTime();
    }

    public static Calendar GetCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }
}

