/*
 * Decompiled with CFR 0.152.
 */
package cn.vorbote.commons;

import cn.vorbote.commons.DateUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapUtil {
    private static final Logger log = LoggerFactory.getLogger(MapUtil.class);
    private static final String DT_SHORT = "short";
    private static final String DT_INT = "int";
    private static final String DT_LONG = "long";
    private static final String DT_BYTE = "byte";
    private static final String DT_CHAR = "char";
    private static final String DT_BOOL = "boolean";
    private static final String DT_FLOAT = "float";
    private static final String DT_DOUBLE = "double";
    private static final String CLASS_STRING = "class java.lang.String";
    private static final String CLASS_BIG_DECIMAL = "class java.math.BigDecimal";
    private static final String CLASS_DATE = "class java.util.Date";
    private static final String CLASS_INTEGER = "class java.lang.Integer";
    private static final String CLASS_SHORT = "class java.lang.Short";
    private static final String CLASS_LONG = "class java.lang.Long";
    private static final String CLASS_BYTE = "class java.lang.Byte";
    private static final String CLASS_CHAR = "class java.lang.Character";
    private static final String CLASS_FLOAT = "class java.lang.Float";
    private static final String CLASS_DOUBLE = "class java.lang.Double";
    private static final String CLASS_BOOL = "class java.lang.Boolean";

    private MapUtil() {
    }

    public static Map<String, Object> SetMap(Object obj) throws Exception {
        Field[] declaredFields;
        if (obj == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field field : declaredFields = obj.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            if (field.get(obj) == null) continue;
            map.put(field.getName(), field.get(obj));
        }
        return map;
    }

    public static void SetObject(Map<String, Object> map, Object obj) {
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                try {
                    String entryValue = entry.getValue().toString();
                    Field field = obj.getClass().getDeclaredField(entry.getKey());
                    switch (field.getGenericType().toString()) {
                        case "short": 
                        case "class java.lang.Short": {
                            entry.setValue(Short.parseShort(entryValue));
                            break;
                        }
                        case "int": 
                        case "class java.lang.Integer": {
                            entry.setValue(Integer.parseInt(entryValue));
                            break;
                        }
                        case "long": 
                        case "class java.lang.Long": {
                            entry.setValue(Long.parseLong(entryValue));
                            break;
                        }
                        case "float": 
                        case "class java.lang.Float": {
                            entry.setValue(Float.valueOf(Float.parseFloat(entryValue)));
                            break;
                        }
                        case "double": 
                        case "class java.lang.Double": {
                            entry.setValue(Double.parseDouble(entryValue));
                            break;
                        }
                        case "char": 
                        case "class java.lang.Character": {
                            entry.setValue(Character.valueOf(entryValue.charAt(0)));
                            break;
                        }
                        case "byte": 
                        case "class java.lang.Byte": {
                            entry.setValue(Byte.parseByte(entryValue));
                            break;
                        }
                        case "boolean": 
                        case "class java.lang.Boolean": {
                            entry.setValue(Boolean.parseBoolean(entryValue));
                            break;
                        }
                        case "class java.lang.String": {
                            entry.setValue(entryValue);
                            break;
                        }
                        case "class java.math.BigDecimal": {
                            entry.setValue(BigDecimal.valueOf(Double.parseDouble(entryValue)));
                            break;
                        }
                        case "class java.util.Date": {
                            entry.setValue(DateUtil.TimestampToDate(entryValue));
                            break;
                        }
                        default: {
                            log.error("Unsupported Type or Class: {}", (Object)field.getGenericType());
                        }
                    }
                    MapUtil.SetFieldValue(entry.getKey(), obj, entry.getValue());
                }
                catch (Exception e) {
                    log.error("Map to Object failed.");
                }
            }
        }
    }

    public static String GetFieldValue(String fieldName, Object obj) throws Exception {
        try {
            String methodName = MapUtil.getMethodName("get", fieldName);
            Method method = MapUtil.getDeclaredMethod(obj, methodName, new Class[0]);
            if (method != null) {
                method.setAccessible(true);
                return MapUtil.defaultObject(method.invoke(obj, new Object[0]));
            }
        }
        catch (Exception ex) {
            log.error("Failed getting object: " + ex.getLocalizedMessage());
            throw new Exception("Failed getting object.");
        }
        return "";
    }

    public static void SetFieldValue(String fieldName, Object obj, Object fieldValue) throws Exception {
        try {
            String methodName = MapUtil.getMethodName("set", fieldName);
            Method method = MapUtil.getDeclaredMethod(obj, methodName, fieldValue.getClass());
            if (method != null) {
                method.setAccessible(true);
                method.invoke(obj, fieldValue);
            }
        }
        catch (Exception ex) {
            throw new Exception("Failed setting object.");
        }
    }

    private static String getMethodName(String prefix, String fieldName) {
        return prefix + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    private static Method getDeclaredMethod(Object object, String methodName, Class<?> ... parameterTypes) {
        for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                Method method = clazz.getDeclaredMethod(methodName, parameterTypes);
                return method;
            }
            catch (Exception exception) {
                continue;
            }
        }
        return null;
    }

    private static String defaultObject(Object obj) {
        if (obj == null) {
            return "";
        }
        return String.valueOf(obj);
    }
}

