/*
 * Decompiled with CFR 0.152.
 */
package cn.vorbote.commons;

import java.util.Collection;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MathUtil {
    private static final Logger log = LoggerFactory.getLogger(MathUtil.class);

    private MathUtil() {
    }

    public static long Factorial(int n) {
        if (n < 0) {
            throw new RuntimeException("A number lower than 0 has no factorial result");
        }
        if (n <= 1) {
            return 1L;
        }
        return (long)n * MathUtil.Factorial(n - 1);
    }

    public static double Sum(Collection<? extends Number> numbers) {
        double sum = 0.0;
        for (Number number : numbers) {
            sum += number.doubleValue();
        }
        return sum;
    }

    public static double Average(Collection<? extends Number> numbers) {
        double sum = MathUtil.Sum(numbers);
        log.debug("sum = {}, size = {}", (Object)sum, (Object)numbers.size());
        return sum / (double)numbers.size();
    }

    public static boolean IsBetween(Number num, Number noLess, Number noGreater) {
        return num.doubleValue() <= noGreater.doubleValue() && num.doubleValue() >= noLess.doubleValue();
    }

    public static boolean IsNotBetween(Number num, Number noLess, Number noGreater) {
        return !MathUtil.IsBetween(num, noLess, noGreater);
    }

    public static String ToHexString(int value, boolean toUpper) {
        Stack<String> stack = new Stack<String>();
        while (value != 0) {
            int temp = value % 16;
            switch (temp) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    stack.push(String.valueOf(temp));
                    break;
                }
                case 10: {
                    stack.push("a");
                    break;
                }
                case 11: {
                    stack.push("b");
                    break;
                }
                case 12: {
                    stack.push("c");
                    break;
                }
                case 13: {
                    stack.push("d");
                    break;
                }
                case 14: {
                    stack.push("e");
                    break;
                }
                case 15: {
                    stack.push("f");
                }
            }
            value /= 16;
        }
        StringBuilder builder = new StringBuilder("0x");
        while (!stack.isEmpty()) {
            String e = (String)stack.pop();
            builder.append(e);
        }
        if (toUpper) {
            return builder.toString().toUpperCase();
        }
        return builder.toString();
    }

    public static String ToBinaryString(int value) {
        Stack<String> stack = new Stack<String>();
        while (value != 0) {
            int temp = value % 2;
            stack.push(String.valueOf(temp));
            value /= 2;
        }
        StringBuilder builder = new StringBuilder("0b");
        while (!stack.isEmpty()) {
            String e = (String)stack.pop();
            builder.append(e);
        }
        return builder.toString();
    }

    public static String ToOctalString(int value) {
        Stack<String> stack = new Stack<String>();
        while (value != 0) {
            int temp = value % 8;
            stack.push(String.valueOf(temp));
            value /= 8;
        }
        StringBuilder builder = new StringBuilder("0");
        while (!stack.isEmpty()) {
            String e = (String)stack.pop();
            builder.append(e);
        }
        return builder.toString();
    }
}

