/*
 * Decompiled with CFR 0.152.
 */
package cn.vorbote.commons;

import cn.vorbote.commons.enums.EncryptMethod;
import cn.vorbote.commons.except.UnsupportedAlgorithmException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HashUtil {
    private static final Logger log = LoggerFactory.getLogger(HashUtil.class);

    private HashUtil() {
    }

    public static String Encrypt(EncryptMethod method, String value) {
        switch (method) {
            case MD2: 
            case MD5: 
            case SHA_1: 
            case SHA_224: 
            case SHA_256: 
            case SHA_384: 
            case SHA_512: {
                break;
            }
            default: {
                throw new UnsupportedAlgorithmException("No such encryption Algorithm");
            }
        }
        String result = "";
        try {
            MessageDigest md = MessageDigest.getInstance(method.ToString());
            md.update(value.getBytes(StandardCharsets.UTF_8));
            byte[] bytes = md.digest();
            StringBuilder builder = new StringBuilder();
            for (byte b : bytes) {
                String str = Integer.toHexString(b & 0xFF);
                if (str.length() == 1) {
                    builder.append("0");
                }
                builder.append(str);
            }
            result = builder.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return result;
    }

    public static String Base64Encode(String value) {
        Base64.Encoder encoder = Base64.getEncoder();
        byte[] encodedString = encoder.encode(value.getBytes(StandardCharsets.UTF_8));
        return new String(encodedString);
    }

    public static String Base64Decode(String value) {
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] decodedString = decoder.decode(value.getBytes(StandardCharsets.UTF_8));
        return new String(decodedString);
    }

    public static String Decrypt(EncryptMethod method, String key, byte[] data) {
        if (method != EncryptMethod.RC4) {
            throw new UnsupportedAlgorithmException("This algorithm is unsupported yet.");
        }
        if (data == null || key == null) {
            return null;
        }
        return HashUtil.asString(HashUtil.rc4Base(data, key));
    }

    public static String Decrypt(EncryptMethod method, String key, String data) {
        if (method != EncryptMethod.RC4) {
            throw new UnsupportedAlgorithmException("This algorithm is unsupported yet.");
        }
        if (data == null || key == null) {
            return null;
        }
        return new String(HashUtil.rc4Base(HashUtil.castHexStringToBytes(data), key));
    }

    public static byte[] EncryptToByteStream(EncryptMethod method, String data, String key) {
        if (method != EncryptMethod.RC4) {
            throw new UnsupportedAlgorithmException("This algorithm is unsupported yet.");
        }
        if (data == null || key == null) {
            return null;
        }
        byte[] b_data = data.getBytes();
        return HashUtil.rc4Base(b_data, key);
    }

    public static String Encrypt(EncryptMethod method, String data, String key) {
        if (data == null || key == null) {
            return null;
        }
        return HashUtil.castToHexString(HashUtil.asString(Objects.requireNonNull(HashUtil.EncryptToByteStream(EncryptMethod.RC4, data, key))));
    }

    private static String asString(byte[] buf) {
        StringBuilder sb = new StringBuilder(buf.length);
        for (byte b : buf) {
            sb.append((char)b);
        }
        return sb.toString();
    }

    private static byte[] initKey(String key) {
        byte[] b_key = key.getBytes(StandardCharsets.UTF_8);
        byte[] state = new byte[256];
        for (int i = 0; i < 256; ++i) {
            state[i] = (byte)i;
        }
        int index1 = 0;
        int index2 = 0;
        if (b_key.length == 0) {
            return null;
        }
        for (int i = 0; i < 256; ++i) {
            index2 = (b_key[index1] & 0xFF) + (state[i] & 0xFF) + index2 & 0xFF;
            byte tmp = state[i];
            state[i] = state[index2];
            state[index2] = tmp;
            index1 = (index1 + 1) % b_key.length;
        }
        return state;
    }

    private static String castToHexString(String s) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            Object s4 = Integer.toHexString(ch & 0xFF);
            if (((String)s4).length() == 1) {
                s4 = "0" + (String)s4;
            }
            str.append((String)s4);
        }
        return str.toString();
    }

    private static byte[] castHexStringToBytes(String src) {
        int size = src.length();
        byte[] ret = new byte[size / 2];
        byte[] tmp = src.getBytes();
        for (int i = 0; i < size / 2; ++i) {
            ret[i] = HashUtil.uniteBytes(tmp[i * 2], tmp[i * 2 + 1]);
        }
        return ret;
    }

    private static byte uniteBytes(byte src0, byte src1) {
        char _b0 = (char)Byte.decode("0x" + new String(new byte[]{src0})).byteValue();
        _b0 = (char)(_b0 << 4);
        char _b1 = (char)Byte.decode("0x" + new String(new byte[]{src1})).byteValue();
        return (byte)(_b0 ^ _b1);
    }

    private static byte[] rc4Base(byte[] input, String m_key) {
        int x = 0;
        int y = 0;
        byte[] key = HashUtil.initKey(m_key);
        byte[] result = new byte[input.length];
        for (int i = 0; i < input.length; ++i) {
            x = x + 1 & 0xFF;
            assert (key != null);
            y = (key[x] & 0xFF) + y & 0xFF;
            byte tmp = key[x];
            key[x] = key[y];
            key[y] = tmp;
            int xorIndex = (key[x] & 0xFF) + (key[y] & 0xFF) & 0xFF;
            result[i] = (byte)(input[i] ^ key[xorIndex]);
        }
        return result;
    }
}

