package cn.vorbote.net;

import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.extern.slf4j.Slf4j;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.Map;

/**
 * This util class supplies POST, GET and other
 * <p>
 * You can see usual User Agents on <br><code>https://www.python87.com/docs/user_agent.html</code>
 */
@Slf4j
public final class RequestUtil {

    private RequestUtil() {
    }

    /**
     * Send a <code>POST</code> request to specified URL
     *
     * @param url    The url you want to send request.
     * @param params The params.
     */
    public static void Post(String url, Map<String, Object> params) {
        try {
            var objectMapper = new ObjectMapper();
            String requestBody = objectMapper
                    .writeValueAsString(params);

            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder()
                    .uri(URI.create(url))
                    .POST(HttpRequest.BodyPublishers.ofString(requestBody))
                    .build();

            HttpResponse<String> response = client.send(request,
                    HttpResponse.BodyHandlers.ofString());

            System.out.println("Response: ----------------------------");
            System.out.println(response.body());
        } catch (Exception e) {
            log.error("An error occurred: {}", (Object) e.getStackTrace());
        }
    }

    /**
     * Send a <code>GET</code> request to specified URL
     *
     * @param url    The url you want to send request.
     * @param params The params.
     */
    public static void Get(String url, Map<String, Object> params) {
        try {
            if (params != null) {
                url += "?";
                StringBuilder strUrl = new StringBuilder(url);
                params.forEach((k, v) -> strUrl.append(String.format("%s=%s", k, v)));
                url = strUrl.toString();
            }

            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder()
                    .uri(URI.create(url))
                    .build();

            HttpResponse<String> response = client.send(request,
                    HttpResponse.BodyHandlers.ofString());

            System.out.println("Response: ----------------------------");
            System.out.println(response.body());
        } catch (Exception e) {
            log.error("An error occurred：{}", (Object) e.getStackTrace());
        }
    }

}
