/*
 * Decompiled with CFR 0.152.
 */
package cn.vorbote.net;

import cn.vorbote.commons.StringUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IpUtil {
    private static final Logger log = LoggerFactory.getLogger(IpUtil.class);
    private static final String LOCALHOST = "127.0.0.1";

    private IpUtil() {
    }

    public static String GetAddress(HttpServletRequest request) {
        String addr;
        try {
            addr = request.getHeader("x-forwarded-for");
            if (StringUtil.IsEmpty((String)addr) || "unknown".equalsIgnoreCase(addr)) {
                addr = request.getHeader("Proxy-Client-IP");
            }
            if (StringUtil.IsEmpty((String)addr) || "unknown".equalsIgnoreCase(addr)) {
                addr = request.getHeader("WL-Proxy-Client-IP");
            }
            if ((StringUtil.IsEmpty((String)addr) || "unknown".equalsIgnoreCase(addr)) && (addr = request.getRemoteAddr()).equals(LOCALHOST)) {
                try {
                    InetAddress inet = InetAddress.getLocalHost();
                    addr = inet.getHostAddress();
                }
                catch (UnknownHostException e) {
                    log.error(String.format("\u52a0\u8f7d\u672c\u5730LOCALHOST\u65f6\u51fa\u73b0\u5f02\u5e38, Trace: %s", Arrays.toString(e.getStackTrace())));
                }
            }
            if (addr != null && addr.length() > 15 && addr.indexOf(",") > 0) {
                addr = addr.substring(0, addr.indexOf(","));
            }
        }
        catch (Exception e) {
            addr = "";
        }
        return addr;
    }
}

