/*
 * Decompiled with CFR 0.152.
 */
package cn.vorbote.net;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestUtil {
    private static final Logger log = LoggerFactory.getLogger(RequestUtil.class);

    private RequestUtil() {
    }

    public static void Post(String url, Map<String, Object> params) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            String requestBody = objectMapper.writeValueAsString(params);
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).POST(HttpRequest.BodyPublishers.ofString(requestBody)).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            System.out.println("Response: ----------------------------");
            System.out.println(response.body());
        }
        catch (Exception e) {
            log.error("An error occurred: {}", (Object)e.getStackTrace());
        }
    }

    public static void Get(String url, Map<String, Object> params) {
        try {
            if (params != null) {
                url = (String)url + "?";
                StringBuilder strUrl = new StringBuilder((String)url);
                params.forEach((k, v) -> strUrl.append(String.format("%s=%s", k, v)));
                url = strUrl.toString();
            }
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create((String)url)).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            System.out.println("Response: ----------------------------");
            System.out.println(response.body());
        }
        catch (Exception e) {
            log.error("An error occurred\uff1a{}", (Object)e.getStackTrace());
        }
    }
}

