/*
 * Decompiled with CFR 0.152.
 */
package cn.vorbote.time;

import cn.vorbote.commons.MathUtil;
import cn.vorbote.commons.StringUtil;
import cn.vorbote.time.TimeSpan;
import cn.vorbote.time.exceptions.TimeOutRangeException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateTime
implements Comparable<DateTime>,
Serializable {
    private long timestamp = System.currentTimeMillis();
    private String pattern = "yyyy-MM-dd HH:mm:ss";

    public DateTime() {
    }

    public DateTime(int year, int month, int date) {
        Calendar calendar = Calendar.getInstance();
        if (MathUtil.IsNotBetween((Number)month, (Number)1, (Number)12)) {
            throw new TimeOutRangeException(StringUtil.Format((String)"The month: {} is out of range of (1 ~ 12).", (Object[])new Object[]{month}));
        }
        int dayInTheMonth = 0;
        switch (month) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                dayInTheMonth = 31;
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                dayInTheMonth = 30;
                break;
            }
            case 2: {
                int n = dayInTheMonth = year % 4 == 0 && year % 100 != 0 || year % 400 == 0 ? 29 : 28;
            }
        }
        if (MathUtil.IsNotBetween((Number)date, (Number)1, (Number)dayInTheMonth)) {
            throw new TimeOutRangeException(StringUtil.Format((String)"The date: {} is out of range of (1 ~ {}).", (Object[])new Object[]{date, dayInTheMonth}));
        }
        calendar.set(year, month - 1, date);
        this.timestamp = calendar.getTimeInMillis();
    }

    public DateTime(int year, int month, int date, int hour, int minute, int second) {
        this(year, month, date);
        if (MathUtil.IsNotBetween((Number)hour, (Number)0, (Number)23)) {
            throw new TimeOutRangeException(StringUtil.Format((String)"The hour: {} is out of range of (0 ~ 23)", (Object[])new Object[]{hour}));
        }
        this.timestamp += 3600L * (long)hour * 1000L;
        if (MathUtil.IsNotBetween((Number)minute, (Number)0, (Number)59)) {
            throw new TimeOutRangeException(StringUtil.Format((String)"The minute: {} is out of range of (0 ~ 59)", (Object[])new Object[]{minute}));
        }
        this.timestamp += 60L * (long)minute * 1000L;
        if (MathUtil.IsNotBetween((Number)minute, (Number)0, (Number)59)) {
            throw new TimeOutRangeException(StringUtil.Format((String)"The second: {} is out of range of (0 ~ 59)", (Object[])new Object[]{second}));
        }
        this.timestamp += (long)second * 1000L;
    }

    public DateTime(int year, int month, int date, int hour, int minute, int second, int mills) {
        this(year, month, date, hour, minute, second);
        if (MathUtil.IsNotBetween((Number)minute, (Number)0, (Number)999)) {
            throw new TimeOutRangeException(StringUtil.Format((String)"The mills: {} is out of range of (0 ~ 59)", (Object[])new Object[]{hour}));
        }
        this.timestamp += (long)mills;
    }

    public long Unix() {
        return this.timestamp / 1000L;
    }

    public DateTime Add(TimeSpan ts) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(this.timestamp));
        calendar.add(1, ts.getYear());
        calendar.add(2, ts.getMonth());
        calendar.add(5, ts.getDate());
        calendar.add(10, ts.getHour());
        calendar.add(12, ts.getMinute());
        calendar.add(13, ts.getSecond());
        calendar.add(14, ts.getMills());
        this.timestamp = calendar.getTimeInMillis();
        return this;
    }

    public DateTime Minus(TimeSpan ts) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(this.timestamp));
        calendar.add(1, -ts.getYear());
        calendar.add(2, -ts.getMonth());
        calendar.add(5, -ts.getDate());
        calendar.add(10, -ts.getHour());
        calendar.add(12, -ts.getMinute());
        calendar.add(13, -ts.getSecond());
        calendar.add(14, -ts.getMills());
        this.timestamp = calendar.getTimeInMillis();
        return this;
    }

    public void Pattern(String pattern) {
        this.pattern = pattern;
    }

    public String Pattern() {
        return this.pattern;
    }

    public void Timestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long Timestamp() {
        return this.timestamp;
    }

    public String toString() {
        SimpleDateFormat formatter = new SimpleDateFormat(this.pattern);
        Date date = new Date(this.timestamp);
        return formatter.format(date);
    }

    public String ToString() {
        SimpleDateFormat formatter = new SimpleDateFormat(this.pattern);
        Date date = new Date(this.timestamp);
        return formatter.format(date);
    }

    @Override
    public int compareTo(DateTime o) {
        return 0;
    }

    public int CompareTo(DateTime o) {
        return (int)(this.Timestamp() - o.Timestamp());
    }

    public static DateTime Now() {
        return new DateTime();
    }
}

