/*
 * Decompiled with CFR 0.152.
 */
package cn.vorbote.time;

import cn.vorbote.commons.StringUtil;

public class TimeSpan {
    private int days;
    private int hours;
    private int minutes;
    private int seconds;
    private int milliseconds;

    public int getDays() {
        return this.days;
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public int getMilliseconds() {
        return this.milliseconds;
    }

    protected void setDays(int days) {
        this.days = days;
    }

    protected void setHours(int hours) {
        this.hours = hours;
    }

    protected void setMinutes(int minutes) {
        this.minutes = minutes;
    }

    protected void setSeconds(int seconds) {
        this.seconds = seconds;
    }

    protected void setMilliseconds(int milliseconds) {
        this.milliseconds = milliseconds;
    }

    public String toString() {
        return StringUtil.Format((String)"{}.{}:{}:{}.{}", (Object[])new Object[]{this.days, String.format("%02d", this.hours), String.format("%02d", this.minutes), String.format("%02d", this.seconds), String.format("%03d", this.milliseconds)});
    }

    public long TotalSeconds() {
        return (long)this.days * 86400L + (long)this.hours * 3600L + (long)this.minutes * 60L + (long)this.seconds;
    }

    public long TotalMilliseconds() {
        return this.TotalSeconds() * 1000L + (long)this.milliseconds;
    }

    public TimeSpan() {
    }

    public TimeSpan(int days, int hours, int minutes, int seconds, int milliseconds) {
        this.days = days;
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
        this.milliseconds = milliseconds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeSpan)) {
            return false;
        }
        TimeSpan other = (TimeSpan)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDays() != other.getDays()) {
            return false;
        }
        if (this.getHours() != other.getHours()) {
            return false;
        }
        if (this.getMinutes() != other.getMinutes()) {
            return false;
        }
        if (this.getSeconds() != other.getSeconds()) {
            return false;
        }
        return this.getMilliseconds() == other.getMilliseconds();
    }

    protected boolean canEqual(Object other) {
        return other instanceof TimeSpan;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDays();
        result = result * 59 + this.getHours();
        result = result * 59 + this.getMinutes();
        result = result * 59 + this.getSeconds();
        result = result * 59 + this.getMilliseconds();
        return result;
    }
}

