/*
 * Decompiled with CFR 0.152.
 */
package cn.vorbote.time;

import cn.vorbote.commons.except.TimeOutRangeException;
import cn.vorbote.time.TimeSpan;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;

public class DateTime
implements Comparable<DateTime>,
Serializable {
    private long timestamp = System.currentTimeMillis();
    private String pattern = "yyyy-MM-dd HH:mm:ss";

    private static void check(int year, int month, int date, int hour, int minute, int second, int mills) {
        if (month <= 0 || month > 12) {
            throw new TimeOutRangeException(String.format("The month: %d is out of range of (1 ~ 12).", month));
        }
        int dayInTheMonth = 0;
        switch (month) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                dayInTheMonth = 31;
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                dayInTheMonth = 30;
                break;
            }
            case 2: {
                int n = dayInTheMonth = year % 4 == 0 && year % 100 != 0 || year % 400 == 0 ? 29 : 28;
            }
        }
        if (date < 1 || date > dayInTheMonth) {
            throw new TimeOutRangeException(String.format("The date: %d is out of range of (1 ~ %d).", date, dayInTheMonth));
        }
        if (hour < 0 || hour > 23) {
            throw new TimeOutRangeException(String.format("The hour: %d is out of range of (0 ~ 23)", hour));
        }
        if (minute < 0 || minute > 59) {
            throw new TimeOutRangeException(String.format("The minute: %d is out of range of (0 ~ 59)", minute));
        }
        if (second < 0 || second > 59) {
            throw new TimeOutRangeException(String.format("The second: %d is out of range of (0 ~ 59)", second));
        }
        if (mills < 0 || mills > 999) {
            throw new TimeOutRangeException(String.format("The mills: %d is out of range of (0 ~ 59)", hour));
        }
    }

    public long getTimestamp() {
        return this.timestamp / 1000L;
    }

    public DateTime() {
    }

    public DateTime(long timestamp) {
        if (String.valueOf(timestamp).matches("\\d{10}")) {
            this.timestamp = timestamp * 1000L;
        } else if (String.valueOf(timestamp).matches("\\d{13}")) {
            this.timestamp = timestamp;
        }
    }

    public DateTime(Date date) {
        this.timestamp = date.getTime();
    }

    public DateTime(Calendar calendar) {
        this.timestamp = calendar.getTimeInMillis();
    }

    public DateTime(int year, int month, int date) {
        Calendar calendar = Calendar.getInstance();
        DateTime.check(year, month, date, 0, 0, 0, 0);
        calendar.set(year, month - 1, date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        this.timestamp = calendar.getTimeInMillis();
    }

    public DateTime(int year, int month, int date, int hour, int minute, int second) {
        DateTime.check(year, month, date, hour, minute, second, 0);
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, date);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, 0);
        this.timestamp = calendar.getTimeInMillis();
    }

    public DateTime(int year, int month, int date, int hour, int minute, int second, int mills) {
        DateTime.check(year, month, date, hour, minute, second, mills);
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, date);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, mills);
        this.timestamp = calendar.getTimeInMillis();
    }

    public long Unix() {
        return this.timestamp / 1000L;
    }

    public DateTime Add(TimeSpan ts) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(this.timestamp));
        calendar.add(5, ts.getDays());
        calendar.add(10, ts.getHours());
        calendar.add(12, ts.getMinutes());
        calendar.add(13, ts.getSeconds());
        calendar.add(14, ts.getMilliseconds());
        this.timestamp = calendar.getTimeInMillis();
        return this;
    }

    public DateTime AddDays(double days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.timestamp);
        int seconds = (int)(days * 24.0 * 60.0 * 60.0);
        calendar.add(13, seconds);
        this.timestamp = calendar.getTimeInMillis();
        return this;
    }

    public DateTime AddHours(double hours) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.timestamp);
        int seconds = (int)(hours * 60.0 * 60.0);
        calendar.add(13, seconds);
        this.timestamp = calendar.getTimeInMillis();
        return this;
    }

    public DateTime AddMilliseconds(int milliseconds) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.timestamp);
        calendar.add(14, milliseconds);
        this.timestamp = calendar.getTimeInMillis();
        return this;
    }

    public DateTime AddMinutes(double minutes) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.timestamp);
        int seconds = (int)(minutes * 60.0);
        calendar.add(13, seconds);
        this.timestamp = calendar.getTimeInMillis();
        return this;
    }

    public DateTime AddMonths(int months) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.timestamp);
        calendar.add(2, months);
        this.timestamp = calendar.getTimeInMillis();
        return this;
    }

    public DateTime AddSeconds(int seconds) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.timestamp);
        calendar.add(13, seconds);
        this.timestamp = calendar.getTimeInMillis();
        return this;
    }

    public DateTime AddYears(int years) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.timestamp);
        calendar.add(1, years);
        this.timestamp = calendar.getTimeInMillis();
        return this;
    }

    public DateTime Minus(TimeSpan ts) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(this.timestamp));
        calendar.add(5, -ts.getDays());
        calendar.add(10, -ts.getHours());
        calendar.add(12, -ts.getMinutes());
        calendar.add(13, -ts.getSeconds());
        calendar.add(14, -ts.getMilliseconds());
        this.timestamp = calendar.getTimeInMillis();
        return this;
    }

    public TimeSpan Minus(DateTime time) {
        TimeSpan span = new TimeSpan();
        if (this == time) {
            return span;
        }
        long ts = this.Timestamp() - time.Timestamp();
        span.setMilliseconds((int)(ts % 1000L));
        span.setDays((int)((ts /= 1000L) / 86400L));
        span.setHours((int)((ts %= 86400L) / 3600L));
        span.setMinutes((int)((ts %= 3600L) / 60L));
        span.setSeconds((int)(ts %= 60L));
        return span;
    }

    public void Pattern(String pattern) {
        this.pattern = pattern;
    }

    public String Pattern() {
        return this.pattern;
    }

    public void Timestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long Timestamp() {
        return this.timestamp;
    }

    public String toString() {
        SimpleDateFormat formatter = new SimpleDateFormat(this.pattern);
        Date date = new Date(this.timestamp);
        return formatter.format(date);
    }

    public String ToString() {
        SimpleDateFormat formatter = new SimpleDateFormat(this.pattern);
        Date date = new Date(this.timestamp);
        return formatter.format(date);
    }

    @Override
    public int compareTo(DateTime o) {
        return (int)(this.Timestamp() - o.Timestamp());
    }

    public int CompareTo(DateTime o) {
        return (int)(this.Timestamp() - o.Timestamp());
    }

    public boolean Equals(DateTime o) {
        return this.Timestamp() == o.Timestamp();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateTime dateTime = (DateTime)o;
        return this.timestamp == dateTime.timestamp;
    }

    public int hashCode() {
        return Objects.hash(this.timestamp);
    }

    public static DateTime Now() {
        return new DateTime();
    }

    public boolean IsLeapYear() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.Timestamp());
        int year = calendar.get(1);
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public Date ToDate() {
        return new Date(this.Timestamp());
    }

    public Calendar ToCalendar() {
        Calendar instance = Calendar.getInstance();
        instance.setTime(this.ToDate());
        return instance;
    }
}

