/*
 * Decompiled with CFR 0.152.
 */
package cn.vorbote.ical;

import cn.vorbote.core.utils.CollectionUtil;
import cn.vorbote.ical.CalendarNode;
import java.util.ArrayList;
import java.util.List;

public final class Calendar {
    private static final String TAG = "VCALENDAR";
    private String name;
    private String companyName;
    private String productName;
    private String domainName;
    private final String scale = "GREGORIAN";
    private String method;
    private final String version = "2.0";
    private List<CalendarNode> nodes = new ArrayList<CalendarNode>();

    public Calendar setName(String name) {
        this.name = name;
        return this;
    }

    public Calendar setCompanyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    public Calendar setDomainName(String domainName) {
        this.domainName = domainName;
        return this;
    }

    public Calendar setProductName(String productName) {
        this.productName = productName;
        return this;
    }

    public Calendar setMethod(String method) {
        this.method = method;
        return this;
    }

    public Calendar addEvent(CalendarNode node) {
        this.nodes.add(node);
        return this;
    }

    public String resolve() {
        StringBuilder events = new StringBuilder();
        if (CollectionUtil.isNotEmpty(this.nodes)) {
            this.nodes.forEach(item -> events.append(item.setDomainName(this.domainName).resolve()));
        }
        return "BEGIN:VCALENDAR\nPRODID:-//" + this.companyName + "//" + this.productName + "//EN\nVERSION:" + "2.0" + "\nX-WR-CALNAME:" + this.name + "\n" + events + "\nEND:" + TAG;
    }
}

