/*
 * Decompiled with CFR 0.152.
 */
package cn.vorbote.ical;

import cn.vorbote.core.time.DateTime;
import cn.vorbote.core.time.TimeSpan;
import cn.vorbote.core.utils.CollectionUtil;
import cn.vorbote.ical.standards.ITimezone;
import cn.vorbote.ical.values.Classification;
import java.util.ArrayList;
import java.util.List;

public abstract class CalendarNode {
    protected List<String> categories = new ArrayList<String>();
    protected Classification classification;
    protected String comment;
    protected String description;
    protected String location;
    protected Integer percentComplete;
    protected Integer priority;
    protected String summary;
    protected DateTime end;
    protected DateTime start;
    protected TimeSpan duration;
    protected String url;
    protected Long uid;
    protected String domainName;
    protected ITimezone timezone;

    protected CalendarNode() {
    }

    public CalendarNode setDomainName(String domainName) {
        this.domainName = domainName;
        return this;
    }

    protected String resolveCategories() {
        StringBuilder builder = new StringBuilder();
        if (CollectionUtil.isNotEmpty(this.categories)) {
            this.categories.forEach(item -> builder.append((String)item).append(","));
            return builder.substring(0, builder.length() - 1);
        }
        return builder.toString();
    }

    public abstract String resolve();
}

