/*
 * Decompiled with CFR 0.152.
 */
package cn.vorbote.ical;

import cn.vorbote.core.time.DateTime;
import cn.vorbote.core.time.TimeSpan;
import cn.vorbote.ical.CalendarNode;
import cn.vorbote.ical.standards.ITimezone;
import cn.vorbote.ical.values.Classification;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;

public final class Event
extends CalendarNode {
    private static final String TAG = "VEVENT";

    public Event addCategories(String ... categories) {
        this.categories.addAll(Arrays.asList(categories));
        return this;
    }

    public Event addCategories(Collection<String> categories) {
        this.categories.addAll(categories);
        return this;
    }

    public Event addCategory(String category) {
        this.categories.add(category);
        return this;
    }

    public Event setClassification(Classification classification) {
        this.classification = classification;
        return this;
    }

    public Event setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public Event setDescription(String description) {
        this.description = description;
        return this;
    }

    public Event setLocation(String location) {
        this.location = location;
        return this;
    }

    public Event setPercentComplete(Integer percentComplete) {
        if (percentComplete < 0 || percentComplete > 100) {
            throw new IllegalArgumentException("Percent out of range (0 ~ 100)");
        }
        this.percentComplete = percentComplete;
        return this;
    }

    public Event setPriority(Integer priority) {
        if (priority < 0 || priority > 9) {
            throw new IllegalArgumentException("The priority you provide is out of range (0 ~ 9).");
        }
        this.priority = priority;
        return this;
    }

    public Event setSummary(String summary) {
        this.summary = summary;
        return this;
    }

    public Event setEnd(DateTime end) {
        if (this.duration != null) {
            throw new IllegalStateException("You have set the field DURATION before, please remove it or remove setEnd.");
        }
        this.end = end;
        return this;
    }

    public Event setStart(DateTime start) {
        this.start = start;
        return this;
    }

    public Event setDuration(TimeSpan duration) {
        if (this.end != null) {
            throw new IllegalStateException("You have set the field END before, please remove it or remove setDuration.");
        }
        this.duration = duration;
        return this;
    }

    public Event setUrl(String url) {
        this.url = url;
        return this;
    }

    public Event setUid(Long uid) {
        this.uid = uid;
        return this;
    }

    @Override
    public Event setDomainName(String domainName) {
        this.domainName = domainName;
        return this;
    }

    public Event setTimezone(ITimezone timezone) {
        this.timezone = timezone;
        return this;
    }

    @Override
    public String resolve() {
        return "\nBEGIN:VEVENT\nUID:" + this.uid + "@" + this.domainName + "\nSUMMARY:" + this.summary + "\nDTSTART" + Optional.ofNullable(this.timezone).map(item -> ";TZID=" + item.getTimezoneId()).orElse("") + ":" + this.start.pattern("yyyyMMdd'T'HHmmss") + "\n" + Optional.ofNullable(this.categories).map(item -> {
            if (!item.isEmpty()) {
                return "CATEGORIES:" + this.resolveCategories() + "\n";
            }
            return null;
        }).orElse("") + Optional.ofNullable(this.duration).map(item -> "DURATION:PT" + item.totalSeconds() + "S\n").orElse("") + Optional.ofNullable(this.end).map(item -> "DTEND:" + this.end.pattern("yyyyMMdd'T'HHmmss") + "\n").orElse("") + Optional.ofNullable(this.classification).map(item -> "CLASS:" + item.getValue() + "\n").orElse("") + Optional.ofNullable(this.comment).map(item -> "COMMENT:" + item + "\n").orElse("") + Optional.ofNullable(this.description).map(item -> "DESCRIPTION:" + item + "\n").orElse("") + Optional.ofNullable(this.location).map(item -> "LOCATION:" + item + "\n").orElse("") + Optional.ofNullable(this.percentComplete).map(item -> "PERCENT-COMPLETE:" + item + "\n").orElse("") + Optional.ofNullable(this.priority).map(item -> "PRIORITY:" + item + "\n").orElse("") + "END:" + TAG + "\n";
    }
}

