/*
 * Decompiled with CFR 0.152.
 */
package cn.vorbote.simplejwt;

import cn.vorbote.core.time.DateTime;
import cn.vorbote.core.time.TimeSpan;
import cn.vorbote.core.utils.MapUtil;
import cn.vorbote.simplejwt.annotations.JwtIgnore;
import cn.vorbote.simplejwt.choices.JwtAlgorithm;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessKeyUtil {
    private static final Logger log = LoggerFactory.getLogger(AccessKeyUtil.class);
    private final JwtAlgorithm algorithm;
    private String secret;
    private String issuer;

    protected String getSecret() {
        return this.secret;
    }

    protected void setSecret(String secret) {
        this.secret = secret;
    }

    protected String getIssuer() {
        return this.issuer;
    }

    protected void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    protected JwtAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public AccessKeyUtil(@NonNull JwtAlgorithm algorithm, @NonNull String secret, @NonNull String issuer) {
        if (algorithm == null) {
            throw new NullPointerException("algorithm is marked non-null but is null");
        }
        if (secret == null) {
            throw new NullPointerException("secret is marked non-null but is null");
        }
        if (issuer == null) {
            throw new NullPointerException("issuer is marked non-null but is null");
        }
        this.algorithm = algorithm;
        this.secret = secret;
        this.issuer = issuer;
    }

    private void buildBasicInfo(String subject, String[] audience, TimeSpan expire, JWTCreator.Builder builder) {
        DateTime now = DateTime.now();
        builder.withIssuer(this.issuer);
        builder.withIssuedAt(now.toDate());
        builder.withNotBefore(now.toDate());
        builder.withAudience(audience);
        builder.withSubject(subject);
        now.add(expire);
        builder.withExpiresAt(now.toDate());
        builder.withJWTId(UUID.randomUUID().toString());
    }

    private void buildClaims(Map<String, Object> claims, JWTCreator.Builder builder) {
        if (claims != null) {
            for (Map.Entry<String, Object> e : claims.entrySet()) {
                builder.withClaim(e.getKey(), e.getValue().toString());
            }
        }
    }

    private String buildToken(JWTCreator.Builder builder) {
        String token;
        switch (this.algorithm) {
            case HS256: {
                token = builder.sign(Algorithm.HMAC256((String)this.secret));
                break;
            }
            case HS384: {
                token = builder.sign(Algorithm.HMAC384((String)this.secret));
                break;
            }
            case HS512: {
                token = builder.sign(Algorithm.HMAC512((String)this.secret));
                break;
            }
            default: {
                token = builder.sign(Algorithm.HMAC256((String)this.secret));
                log.error("This algorithm is not supported yet, will use HMAC256 by default.");
            }
        }
        return token;
    }

    public String createToken(TimeSpan expire, String subject, String[] audience, Map<String, Object> claims) {
        JWTCreator.Builder builder = JWT.create();
        this.buildBasicInfo(subject, audience, expire, builder);
        this.buildClaims(claims, builder);
        return this.buildToken(builder);
    }

    public String createTokenWithBean(TimeSpan expire, String subject, String[] audience, Object bean) throws Exception {
        Field[] fields;
        JWTCreator.Builder builder = JWT.create();
        this.buildBasicInfo(subject, audience, expire, builder);
        Class<?> beanClass = bean.getClass();
        for (Field field : fields = beanClass.getDeclaredFields()) {
            if (field.isAnnotationPresent(JwtIgnore.class)) continue;
            field.setAccessible(true);
            String fieldName = field.getName();
            Object fieldValue = field.get(bean);
            if (fieldValue == null) continue;
            if (fieldValue instanceof Boolean) {
                Boolean v = (Boolean)fieldValue;
                builder.withClaim(fieldName, v);
                continue;
            }
            if (fieldValue instanceof Double) {
                Double v = (Double)fieldValue;
                builder.withClaim(fieldName, v);
                continue;
            }
            if (fieldValue instanceof Float) {
                Float v = (Float)fieldValue;
                builder.withClaim(fieldName, Double.valueOf(v.doubleValue()));
                continue;
            }
            if (fieldValue instanceof Integer) {
                Integer v = (Integer)fieldValue;
                builder.withClaim(fieldName, v);
                continue;
            }
            if (fieldValue instanceof Long) {
                Long v = (Long)fieldValue;
                builder.withClaim(fieldName, v);
                continue;
            }
            if (fieldValue instanceof String) {
                String v = (String)fieldValue;
                builder.withClaim(fieldName, v);
                continue;
            }
            if (fieldValue instanceof Date) {
                Date v = (Date)fieldValue;
                builder.withClaim(fieldName, v);
                continue;
            }
            if (fieldValue instanceof DateTime) {
                DateTime v = (DateTime)fieldValue;
                builder.withClaim(fieldName, v.toDate());
                continue;
            }
            if (fieldValue instanceof List) {
                List v = (List)fieldValue;
                builder.withClaim(fieldName, v);
                continue;
            }
            log.error("Unsupported data type! Data will be automatically converted to String for storage. Make sure the toString() method of this class has been overridden!");
            builder.withClaim(fieldName, fieldValue.toString());
        }
        return this.buildToken(builder);
    }

    public void verify(String token) {
        this.info(token);
    }

    public DecodedJWT info(String token) {
        JWTVerifier verifier;
        switch (this.algorithm) {
            case HS256: {
                verifier = JWT.require((Algorithm)Algorithm.HMAC256((String)this.secret)).build();
                break;
            }
            case HS384: {
                verifier = JWT.require((Algorithm)Algorithm.HMAC384((String)this.secret)).build();
                break;
            }
            case HS512: {
                verifier = JWT.require((Algorithm)Algorithm.HMAC512((String)this.secret)).build();
                break;
            }
            default: {
                verifier = JWT.require((Algorithm)Algorithm.HMAC256((String)this.secret)).build();
                log.error("This algorithm is not supported yet, will use HMAC256 by default.");
            }
        }
        return verifier.verify(token);
    }

    @Deprecated
    public String renew(String token, int expireAfter) {
        return this.renew(token, TimeSpan.builder().seconds(expireAfter).build());
    }

    public String renew(String token, TimeSpan expireAfter) {
        DecodedJWT info = this.info(token);
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<String> keys = Arrays.asList("aud", "sub", "nbf", "iss", "exp", "iat", "jti");
        for (Map.Entry e : info.getClaims().entrySet()) {
            if (keys.contains(e.getKey())) continue;
            map.put((String)e.getKey(), ((Claim)e.getValue()).asString());
        }
        String[] audiences = info.getAudience().toArray(new String[0]);
        return this.createToken(expireAfter, info.getSubject(), audiences, map);
    }

    public String renewWithBean(String token, TimeSpan expireAfter, Class<?> requiredType) throws Exception {
        DecodedJWT info = this.info(token);
        Object bean = this.getBean(token, requiredType);
        String[] audiences = info.getAudience().toArray(new String[0]);
        return this.createTokenWithBean(expireAfter, info.getSubject(), audiences, bean);
    }

    public <T> T getBean(String token, Class<T> requiredType) throws Exception {
        Field[] fields;
        Map tokenInfo = this.info(token).getClaims();
        T bean = requiredType.getConstructor(new Class[0]).newInstance(new Object[0]);
        for (Field field : fields = requiredType.getDeclaredFields()) {
            Object fieldValue;
            String fieldName;
            if (field.isAnnotationPresent(JwtIgnore.class) || (fieldName = field.getName()).equalsIgnoreCase("log") || fieldName.equalsIgnoreCase("logger") || (fieldValue = Optional.ofNullable((Claim)tokenInfo.get(fieldName)).map(claim -> claim.as(field.getType())).orElse(null)) == null) continue;
            log.debug("\u4e3a{}\u6ce8\u5165\u6570\u636e\uff1a{}", (Object)fieldName, fieldValue);
            log.debug("\u6570\u636e\u503c\uff1a{}\uff0c\u6570\u636e\u7c7b\u578b\uff1a{}", fieldValue, fieldValue.getClass());
            MapUtil.setFieldValue(bean, (String)fieldName, (Object)fieldValue);
        }
        return bean;
    }
}

