/*
 * Decompiled with CFR 0.152.
 */
package cn.w2n0.genghiskhan.cache;

import java.util.List;
import org.springframework.data.redis.core.RedisTemplate;

public class ListCache {
    public RedisTemplate redisTemplate;

    public ListCache(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public void delete(String key) {
        this.redisTemplate.delete((Object)key);
    }

    public <T> void lpush(String key, T value) {
        this.redisTemplate.opsForList().leftPush((Object)key, value);
    }

    public <T> T index(String key, int index) {
        return (T)this.redisTemplate.opsForList().index((Object)key, (long)index);
    }

    public <T> List<T> range(String key, int start, int end) {
        return this.redisTemplate.opsForList().range((Object)key, (long)start, (long)end);
    }

    public <T> T lpop(String key) {
        return (T)this.redisTemplate.opsForList().leftPop((Object)key);
    }

    public Long size(String key) {
        return this.redisTemplate.opsForList().size((Object)key);
    }

    public <T> void set(String key, Integer index, T value) {
        this.redisTemplate.opsForList().set((Object)key, (long)index.intValue(), value);
    }

    public void trim(String key, Integer start, Integer end) {
        this.redisTemplate.opsForList().trim((Object)key, (long)start.intValue(), (long)end.intValue());
    }

    public <T> void remove(String key, T value, int count) {
        this.redisTemplate.opsForList().remove((Object)key, (long)count, value);
    }
}

