/*
 * Decompiled with CFR 0.152.
 */
package cn.w2n0.genghiskhan.cache;

import java.util.Set;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;

public class ZsetCache {
    public RedisTemplate redisTemplate;

    public ZsetCache(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public <T> void add(String key, T value, double score) {
        this.redisTemplate.opsForZSet().add((Object)key, value, score);
    }

    public <T> void remove(String key, T value) {
        this.redisTemplate.opsForZSet().remove((Object)key, new Object[]{value});
    }

    public <T> Double incrScore(String key, T value, double score) {
        return this.redisTemplate.opsForZSet().incrementScore((Object)key, value, score);
    }

    public <T> Double score(String key, T value) {
        return this.redisTemplate.opsForZSet().score((Object)key, value);
    }

    public <T> Long rank(String key, T value) {
        return this.redisTemplate.opsForZSet().rank((Object)key, value);
    }

    public <T> Set<T> range(String key, int start, int end) {
        return this.redisTemplate.opsForZSet().range((Object)key, (long)start, (long)end);
    }

    public <T> Set<ZSetOperations.TypedTuple<T>> rangeWithScore(String key, int start, int end) {
        return this.redisTemplate.opsForZSet().rangeWithScores((Object)key, (long)start, (long)end);
    }

    public <T> Set<T> revRange(String key, int start, int end) {
        return this.redisTemplate.opsForZSet().reverseRange((Object)key, (long)start, (long)end);
    }

    public <T> Set<T> sortRange(String key, int min, int max) {
        return this.redisTemplate.opsForZSet().rangeByScore((Object)key, (double)min, (double)max);
    }

    public Long size(String key) {
        return this.redisTemplate.opsForZSet().zCard((Object)key);
    }
}

