/*
 * Decompiled with CFR 0.152.
 */
package cn.wangcaitao.global.handler;

import cn.wangcaitao.common.entity.Result;
import cn.wangcaitao.common.exception.ResultException;
import cn.wangcaitao.common.util.ResultUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.servlet.NoHandlerFoundException;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    public Result handlerException(Exception e) {
        if (e instanceof NoHandlerFoundException) {
            return ResultUtils.error((int)404, (String)"\u8d44\u6e90\u4e0d\u5b58\u5728");
        }
        if (e instanceof BindException) {
            return ResultUtils.error((int)400, (String)((FieldError)((BindException)e).getFieldErrors().get(0)).getDefaultMessage());
        }
        if (e instanceof MethodArgumentNotValidException) {
            return ResultUtils.error((int)400, (String)((FieldError)((MethodArgumentNotValidException)e).getBindingResult().getFieldErrors().get(0)).getDefaultMessage());
        }
        if (e instanceof AccessDeniedException) {
            return ResultUtils.error((int)403, (String)"\u6743\u9650\u4e0d\u8db3");
        }
        if (e instanceof HttpRequestMethodNotSupportedException) {
            return ResultUtils.error((int)405, (String)"\u8bf7\u6c42\u65b9\u5f0f\u9519\u8bef");
        }
        if (e instanceof ResultException) {
            String params = ((ResultException)e).getParams();
            if (StringUtils.isNotEmpty((CharSequence)params)) {
                LOGGER.error("request params: {}", (Object)params, (Object)e);
            }
            return ResultUtils.error((int)((ResultException)e).getCode(), (String)((ResultException)e).getMsg());
        }
        if (e instanceof HttpMessageNotReadableException) {
            return ResultUtils.error((int)400, (String)(null == e.getCause() ? "\u7f3a\u5c11\u8bf7\u6c42\u53c2\u6570" : e.getCause().getLocalizedMessage()));
        }
        if (e instanceof HttpMediaTypeNotSupportedException) {
            return ResultUtils.error((int)415, (String)"Content-Type \u9519\u8bef");
        }
        if (e instanceof MethodArgumentTypeMismatchException) {
            return ResultUtils.error((int)400, (String)e.getMessage());
        }
        if (e instanceof ServletRequestBindingException) {
            return ResultUtils.error((int)400, (String)e.getMessage());
        }
        if (e instanceof HttpClientErrorException) {
            return ResultUtils.error((int)400, (String)"\u6388\u6743\u5931\u8d25");
        }
        LOGGER.error("un handle exception: {}", (Object)e.getClass().getName());
        return ResultUtils.error((int)500, (String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef");
    }
}

