/*
 * Decompiled with CFR 0.152.
 */
package cn.wanghaomiao.xpath.core;

import cn.wanghaomiao.xpath.model.JXNode;
import cn.wanghaomiao.xpath.util.CommonUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class Functions {
    public List<JXNode> text(Elements context) {
        LinkedList<JXNode> res = new LinkedList<JXNode>();
        if (context != null && context.size() > 0) {
            for (Element e : context) {
                if (e.nodeName().equals("script")) {
                    res.add(JXNode.t(e.data()));
                    continue;
                }
                res.add(JXNode.t(e.ownText()));
            }
        }
        return res;
    }

    public List<JXNode> allText(Elements context) {
        LinkedList<JXNode> res = new LinkedList<JXNode>();
        if (context != null && context.size() > 0) {
            for (Element e : context) {
                res.add(JXNode.t(e.text()));
            }
        }
        return res;
    }

    public List<JXNode> html(Elements context) {
        LinkedList<JXNode> res = new LinkedList<JXNode>();
        if (context != null && context.size() > 0) {
            for (Element e : context) {
                res.add(JXNode.t(e.html()));
            }
        }
        return res;
    }

    public List<JXNode> outerHtml(Elements context) {
        LinkedList<JXNode> res = new LinkedList<JXNode>();
        if (context != null && context.size() > 0) {
            for (Element e : context) {
                res.add(JXNode.t(e.outerHtml()));
            }
        }
        return res;
    }

    public List<JXNode> node(Elements context) {
        return this.html(context);
    }

    public List<JXNode> num(Elements context) {
        LinkedList<JXNode> res = new LinkedList<JXNode>();
        if (context != null) {
            Pattern pattern = Pattern.compile("\\d+");
            for (Element e : context) {
                Matcher matcher = pattern.matcher(e.ownText());
                if (!matcher.find()) continue;
                res.add(JXNode.t(matcher.group()));
            }
        }
        return res;
    }

    public String text(Element e) {
        return e.ownText();
    }

    public String allText(Element e) {
        return e.text();
    }

    public boolean last(Element e) {
        return CommonUtil.getElIndexInSameTags(e) == CommonUtil.sameTagElNums(e);
    }

    public boolean first(Element e) {
        return CommonUtil.getElIndexInSameTags(e) == 1;
    }

    public int position(Element e) {
        return CommonUtil.getElIndexInSameTags(e);
    }

    public boolean contains(String left, String right) {
        return left.contains(right);
    }
}

