/*
 * Decompiled with CFR 0.152.
 */
package org.seimicrawler.xpath.core;

import java.util.Collection;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.seimicrawler.xpath.exception.XpathParserException;

public class Scope {
    private Elements context = new Elements();
    private boolean isRecursion = false;
    private Scope parent;

    private Scope(Elements context) {
        this.context.addAll((Collection)context);
    }

    private Scope(Element context) {
        this.context.add((Object)context);
    }

    public static Scope create(Elements elements) {
        return new Scope(elements);
    }

    public static Scope create(Element el) {
        return new Scope(el);
    }

    public static Scope create(Scope scope) {
        return new Scope(scope.context()).setParent(scope);
    }

    public Scope setParent(Scope scope) {
        this.parent = scope;
        return this;
    }

    public Scope getParent() {
        return this.parent;
    }

    public void setContext(Elements context) {
        this.context = context;
    }

    public boolean isRecursion() {
        return this.isRecursion;
    }

    void recursion() {
        this.isRecursion = true;
    }

    public void notRecursion() {
        this.isRecursion = false;
    }

    public Elements context() {
        return this.context;
    }

    public Element singleEl() {
        if (this.context.size() == 1) {
            return this.context.first();
        }
        throw new XpathParserException("current context is more than one el,total = " + this.context.size());
    }
}

