/*
 * Decompiled with CFR 0.152.
 */
package cn.wanghaomiao.seimi.core;

import cn.wanghaomiao.seimi.annotation.Interceptor;
import cn.wanghaomiao.seimi.core.SeimiInterceptor;
import cn.wanghaomiao.seimi.core.SeimiQueue;
import cn.wanghaomiao.seimi.def.BaseSeimiCrawler;
import cn.wanghaomiao.seimi.http.HttpClientFactory;
import cn.wanghaomiao.seimi.http.HttpMethod;
import cn.wanghaomiao.seimi.struct.BodyType;
import cn.wanghaomiao.seimi.struct.CrawlerModel;
import cn.wanghaomiao.seimi.struct.Request;
import cn.wanghaomiao.seimi.struct.Response;
import cn.wanghaomiao.seimi.utils.StructValidator;
import cn.wanghaomiao.xpath.exception.NoSuchAxisException;
import cn.wanghaomiao.xpath.exception.NoSuchFunctionException;
import cn.wanghaomiao.xpath.exception.XpathSyntaxErrorException;
import cn.wanghaomiao.xpath.model.JXDocument;
import com.alibaba.fastjson.JSON;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeimiProcessor
implements Runnable {
    private SeimiQueue queue;
    private List<SeimiInterceptor> interceptors;
    private CrawlerModel crawlerModel;
    private BaseSeimiCrawler crawler;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public SeimiProcessor(List<SeimiInterceptor> interceptors, CrawlerModel crawlerModel) {
        this.queue = crawlerModel.getQueueInstance();
        this.interceptors = interceptors;
        this.crawlerModel = crawlerModel;
        this.crawler = crawlerModel.getInstance();
    }

    @Override
    public void run() {
        block2: while (true) {
            try {
                while (true) {
                    Interceptor interAnno;
                    Request request;
                    if ((request = this.queue.bPop(this.crawlerModel.getCrawlerName())) == null) {
                        continue;
                    }
                    if (this.crawlerModel == null) {
                        this.logger.error("No such crawler name:'{}'", (Object)request.getCrawlerName());
                        continue;
                    }
                    if (request.isStop()) {
                        this.logger.info("SeimiProcessor[{}] will stop!", (Object)Thread.currentThread().getName());
                        break block2;
                    }
                    if (!StructValidator.validateAnno(request)) {
                        this.logger.warn("Request={} is illegal", (Object)JSON.toJSONString((Object)request));
                        continue;
                    }
                    if (!StructValidator.validateAllowRules(this.crawler.allowRules(), request.getUrl())) {
                        this.logger.warn("Request={} will be dropped by allowRules=[{}]", (Object)JSON.toJSONString((Object)request), (Object)StringUtils.join((Object[])this.crawler.allowRules(), (String)","));
                        continue;
                    }
                    if (StructValidator.validateDenyRules(this.crawler.denyRules(), request.getUrl())) {
                        this.logger.warn("Request={} will be dropped by denyRules=[{}]", (Object)JSON.toJSONString((Object)request), (Object)StringUtils.join((Object[])this.crawler.denyRules(), (String)","));
                        continue;
                    }
                    if (this.queue.isProcessed(request)) {
                        this.logger.info("This request has bean processed,so current request={} will be dropped!", (Object)JSON.toJSONString((Object)request));
                        continue;
                    }
                    HttpClient hc = this.crawlerModel.isUseCookie() ? HttpClientFactory.getHttpClient(10000, this.crawlerModel.getInstance().getCookieStore()) : HttpClientFactory.getHttpClient();
                    RequestConfig config = RequestConfig.custom().setProxy(this.crawlerModel.getProxy()).build();
                    RequestBuilder requestBuilder = HttpMethod.POST.equals((Object)request.getHttpMethod()) ? RequestBuilder.post().setUri(request.getUrl()) : RequestBuilder.get().setUri(request.getUrl());
                    if (request.getParams() != null) {
                        for (Map.Entry<String, String> entry : request.getParams().entrySet()) {
                            requestBuilder.addParameter(entry.getKey(), entry.getValue());
                        }
                    }
                    requestBuilder.setConfig(config);
                    HttpResponse httpResponse = hc.execute(requestBuilder.build());
                    Response seimiResponse = this.renderResponse(httpResponse, request);
                    Method requestCallback = this.crawlerModel.getMemberMethods().get(request.getCallBack());
                    if (requestCallback == null) continue;
                    for (SeimiInterceptor interceptor : this.interceptors) {
                        interAnno = interceptor.getClass().getAnnotation(Interceptor.class);
                        if (!interAnno.everyMethod() && !requestCallback.isAnnotationPresent(interceptor.getTargetAnnotationClass()) && !this.crawlerModel.getClazz().isAnnotationPresent(interceptor.getTargetAnnotationClass())) continue;
                        interceptor.before(requestCallback, seimiResponse);
                    }
                    if (this.crawlerModel.getDelay() > 0) {
                        TimeUnit.SECONDS.sleep(this.crawlerModel.getDelay());
                    }
                    requestCallback.invoke((Object)this.crawlerModel.getInstance(), seimiResponse);
                    for (SeimiInterceptor interceptor : this.interceptors) {
                        interAnno = interceptor.getClass().getAnnotation(Interceptor.class);
                        if (!interAnno.everyMethod() && !requestCallback.isAnnotationPresent(interceptor.getTargetAnnotationClass()) && !this.crawlerModel.getClazz().isAnnotationPresent(interceptor.getTargetAnnotationClass())) continue;
                        interceptor.after(requestCallback, seimiResponse);
                    }
                    this.logger.debug("Crawler[{}] ,url={} ,responseStatus={}", new Object[]{this.crawlerModel.getCrawlerName(), request.getUrl(), httpResponse.getStatusLine().getStatusCode()});
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                continue;
            }
            break;
        }
    }

    private Response renderResponse(HttpResponse httpResponse, Request request) {
        Response seimiResponse;
        block9: {
            seimiResponse = new Response();
            HttpEntity entity = httpResponse.getEntity();
            seimiResponse.setHttpResponse(httpResponse);
            seimiResponse.setReponseEntity(entity);
            seimiResponse.setUrl(request.getUrl());
            seimiResponse.setRequest(request);
            if (entity != null) {
                Header referer = httpResponse.getFirstHeader("Referer");
                if (referer != null) {
                    seimiResponse.setReferer(referer.getValue());
                }
                if (!entity.getContentType().getValue().contains("image")) {
                    seimiResponse.setBodyType(BodyType.TEXT);
                    try {
                        seimiResponse.setData(EntityUtils.toByteArray((HttpEntity)entity));
                        ContentType contentType = ContentType.get((HttpEntity)entity);
                        Charset charset = contentType.getCharset();
                        if (charset == null) {
                            seimiResponse.setContent(new String(seimiResponse.getData(), "ISO-8859-1"));
                            String docCharset = this.renderRealCharset(seimiResponse);
                            seimiResponse.setContent(new String(seimiResponse.getContent().getBytes("ISO-8859-1"), docCharset));
                            break block9;
                        }
                        seimiResponse.setContent(new String(seimiResponse.getData(), charset));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.logger.error("no content data");
                    }
                } else {
                    seimiResponse.setBodyType(BodyType.BINARY);
                    try {
                        seimiResponse.setData(EntityUtils.toByteArray((HttpEntity)entity));
                        seimiResponse.setContent(StringUtils.substringAfterLast((String)request.getUrl(), (String)"/"));
                    }
                    catch (Exception e) {
                        this.logger.error("no data can be read from httpResponse");
                    }
                }
            }
        }
        return seimiResponse;
    }

    public String renderRealCharset(Response response) throws NoSuchFunctionException, XpathSyntaxErrorException, NoSuchAxisException {
        String ct;
        JXDocument doc = response.document();
        String charset = StringUtils.join((Iterable)doc.sel("//meta[@charset]/@charset"), (String)"").trim();
        if (StringUtils.isBlank((CharSequence)charset)) {
            charset = StringUtils.join((Iterable)doc.sel("//meta[@http-equiv='charset']/@content"), (String)"").trim();
        }
        if (StringUtils.isBlank((CharSequence)charset) && (ct = StringUtils.join((Iterable)doc.sel("//meta[@http-equiv='Content-Type']/@content|//meta[@http-equiv='content-type']/@content"), (String)"").trim()).toLowerCase().contains("charset")) {
            charset = ct.split(";")[1].trim().split("=")[1];
        }
        return StringUtils.isNotBlank((CharSequence)charset) ? charset : "UTF-8";
    }
}

