/*
 * Decompiled with CFR 0.152.
 */
package cn.wanghaomiao.seimi.utils;

import cn.wanghaomiao.seimi.core.CastToNumber;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class GenericUtils {
    private static final Class<?>[] EMPTY_CLASSES = new Class[0];
    private static final Map<Class, CastToNumber> numberClass = new HashMap<Class, CastToNumber>(){
        {
            this.put(Integer.TYPE, new CastToNumber(){

                @Override
                public Object castTo(String ori) {
                    return new BigDecimal(ori).intValue();
                }
            });
            this.put(Integer.class, new CastToNumber(){

                @Override
                public Object castTo(String ori) {
                    return new BigDecimal(ori).intValue();
                }
            });
            this.put(Long.TYPE, new CastToNumber(){

                @Override
                public Object castTo(String ori) {
                    return new BigDecimal(ori).longValue();
                }
            });
            this.put(Long.class, new CastToNumber(){

                @Override
                public Object castTo(String ori) {
                    return new BigDecimal(ori).longValue();
                }
            });
            this.put(Short.TYPE, new CastToNumber(){

                @Override
                public Object castTo(String ori) {
                    return new BigDecimal(ori).shortValue();
                }
            });
            this.put(Short.class, new CastToNumber(){

                @Override
                public Object castTo(String ori) {
                    return new BigDecimal(ori).shortValue();
                }
            });
            this.put(Float.TYPE, new CastToNumber(){

                @Override
                public Object castTo(String ori) {
                    return Float.valueOf(new BigDecimal(ori).floatValue());
                }
            });
            this.put(Float.class, new CastToNumber(){

                @Override
                public Object castTo(String ori) {
                    return Float.valueOf(new BigDecimal(ori).floatValue());
                }
            });
            this.put(Double.TYPE, new CastToNumber(){

                @Override
                public Object castTo(String ori) {
                    return new BigDecimal(ori).doubleValue();
                }
            });
            this.put(Double.class, new CastToNumber(){

                @Override
                public Object castTo(String ori) {
                    return new BigDecimal(ori).doubleValue();
                }
            });
        }
    };

    public static Class<?>[] getActualClass(Type genericType) {
        if (genericType instanceof ParameterizedType) {
            Type[] actualTypes = ((ParameterizedType)genericType).getActualTypeArguments();
            Class[] actualClasses = new Class[actualTypes.length];
            for (int i = 0; i < actualTypes.length; ++i) {
                Type actualType = actualTypes[i];
                if (actualType instanceof Class) {
                    actualClasses[i] = (Class)actualType;
                    continue;
                }
                if (!(actualType instanceof GenericArrayType)) continue;
                Type componentType = ((GenericArrayType)actualType).getGenericComponentType();
                actualClasses[i] = Array.newInstance((Class)componentType, 0).getClass();
            }
            return actualClasses;
        }
        return EMPTY_CLASSES;
    }

    public static boolean isNumber(Class cls) {
        return numberClass.containsKey(cls);
    }

    public static Object castToNumber(Class cls, String val) {
        return numberClass.get(cls).castTo(val);
    }
}

