/*
 * Decompiled with CFR 0.152.
 */
package cn.wanghaomiao.seimi.struct;

import cn.wanghaomiao.seimi.annotation.Crawler;
import cn.wanghaomiao.seimi.core.SeimiQueue;
import cn.wanghaomiao.seimi.def.BaseSeimiCrawler;
import cn.wanghaomiao.seimi.utils.StrFormatUtil;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class CrawlerModel {
    private ApplicationContext context;
    private BaseSeimiCrawler instance;
    private Class<? extends BaseSeimiCrawler> clazz;
    private SeimiQueue queueInstance;
    private Class<? extends SeimiQueue> queueClass;
    private Map<String, Method> memberMethods;
    private String crawlerName;
    private HttpHost proxy;
    private boolean useCookie = false;
    private boolean useUnrepeated = true;
    private int delay = 0;
    private Logger logger = LoggerFactory.getLogger(CrawlerModel.class);

    public CrawlerModel(Class<? extends BaseSeimiCrawler> cls, ApplicationContext applicationContext) {
        this.context = applicationContext;
        this.clazz = cls;
        this.instance = (BaseSeimiCrawler)this.context.getBean(cls);
        this.init();
    }

    private void init() {
        Crawler c = this.clazz.getAnnotation(Crawler.class);
        Assert.notNull((Object)c, (String)StrFormatUtil.info("crawler {} lost annotation @cn.wanghaomiao.seimi.annotation.Crawler!", this.clazz.getName()));
        this.queueClass = c.queue();
        this.queueInstance = (SeimiQueue)this.context.getBean(this.queueClass);
        Assert.notNull((Object)this.queueInstance, (String)StrFormatUtil.info("can not get {} instance,please check scan path", this.queueClass));
        this.instance.setQueue(this.queueInstance);
        this.memberMethods = new HashMap<String, Method>();
        ReflectionUtils.doWithMethods(this.clazz, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                CrawlerModel.this.memberMethods.put(method.getName(), method);
            }
        });
        this.crawlerName = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{c.name()}) ? c.name() : this.clazz.getSimpleName();
        this.instance.setCrawlerName(this.crawlerName);
        this.resolveProxy(c.proxy());
        this.useCookie = c.useCookie();
        this.delay = c.delay();
        this.useUnrepeated = c.useUnrepeated();
        this.logger.info("Crawler[{}] init complete.", (Object)this.crawlerName);
    }

    private HttpHost resolveProxy(String proxyStr) {
        HttpHost r = null;
        if (StringUtils.isBlank((CharSequence)proxyStr)) {
            return null;
        }
        if (proxyStr.matches("(http|https|socket)://([0-9a-zA-Z]+\\.?)+:\\d+")) {
            String[] pies = proxyStr.split(":");
            String scheme = pies[0];
            int port = Integer.parseInt(pies[2]);
            String host = pies[1].substring(2);
            r = scheme.equals("socket") ? new HttpHost(host, port) : new HttpHost(host, port, scheme);
        } else {
            this.logger.error("proxy must like \u2018http|https|socket://host:port\u2019");
        }
        this.proxy = r;
        return r;
    }

    public ApplicationContext getContext() {
        return this.context;
    }

    public void setContext(ApplicationContext context) {
        this.context = context;
    }

    public BaseSeimiCrawler getInstance() {
        return this.instance;
    }

    public void setInstance(BaseSeimiCrawler instance) {
        this.instance = instance;
    }

    public Class<? extends BaseSeimiCrawler> getClazz() {
        return this.clazz;
    }

    public void setClazz(Class<? extends BaseSeimiCrawler> clazz) {
        this.clazz = clazz;
    }

    public SeimiQueue getQueueInstance() {
        return this.queueInstance;
    }

    public void setqueueImpl(SeimiQueue queueImpl) {
        this.queueInstance = queueImpl;
    }

    public Class<? extends SeimiQueue> getqueueClass() {
        return this.queueClass;
    }

    public void setqueueClass(Class<? extends SeimiQueue> queueClass) {
        this.queueClass = queueClass;
    }

    public Map<String, Method> getMemberMethods() {
        return this.memberMethods;
    }

    public void setMemberMethods(Map<String, Method> memberMethods) {
        this.memberMethods = memberMethods;
    }

    public String getCrawlerName() {
        return this.crawlerName;
    }

    public HttpHost getProxy() {
        if (StringUtils.isNotBlank((CharSequence)this.instance.proxy())) {
            return this.resolveProxy(this.instance.proxy());
        }
        return this.proxy;
    }

    public boolean isUseCookie() {
        return this.useCookie;
    }

    public int getDelay() {
        return this.delay;
    }

    public boolean isUseUnrepeated() {
        return this.useUnrepeated;
    }
}

