/*
 * Decompiled with CFR 0.152.
 */
package cn.wanghaomiao.seimi.core;

import cn.wanghaomiao.seimi.def.BaseSeimiCrawler;
import cn.wanghaomiao.seimi.http.HttpMethod;
import cn.wanghaomiao.seimi.struct.CrawlerModel;
import cn.wanghaomiao.seimi.struct.Request;
import com.alibaba.fastjson.JSON;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.RequestBuilder;

public class RequestGenerator {
    public static RequestBuilder getHttpRequestBuilder(Request request, CrawlerModel crawlerModel) {
        RequestBuilder requestBuilder;
        BaseSeimiCrawler crawler = crawlerModel.getInstance();
        if (request.isUseSeimiAgent()) {
            String seimiAgentUrl = "http://" + crawler.seiAgentHost() + (crawler.seimiAgentPort() != 80 ? ":" + crawler.seimiAgentPort() : "") + "/doload";
            requestBuilder = RequestBuilder.post().setUri(seimiAgentUrl);
            requestBuilder.addParameter("url", request.getUrl());
            if (StringUtils.isNotBlank((String)crawler.proxy())) {
                requestBuilder.addParameter("proxy", crawler.proxy());
            }
            if (request.getSeimiAgentRenderTime() > 0L) {
                requestBuilder.addParameter("renderTime", String.valueOf(request.getSeimiAgentRenderTime()));
            }
            if (StringUtils.isNotBlank((String)request.getSeimiAgentScript())) {
                requestBuilder.addParameter("script", request.getSeimiAgentScript());
            }
            if (request.isSeimiAgentUseCookie() == null && crawlerModel.isUseCookie() || request.isSeimiAgentUseCookie() != null && request.isSeimiAgentUseCookie().booleanValue()) {
                requestBuilder.addParameter("useCookie", "1");
            }
            if (request.getParams() != null && request.getParams().size() > 0) {
                requestBuilder.addParameter("postParam", JSON.toJSONString(request.getParams()));
            }
        } else {
            requestBuilder = HttpMethod.POST.equals((Object)request.getHttpMethod()) ? RequestBuilder.post().setUri(request.getUrl()) : RequestBuilder.get().setUri(request.getUrl());
            RequestConfig config = RequestConfig.custom().setProxy(crawlerModel.getProxy()).build();
            if (request.getParams() != null) {
                for (Map.Entry<String, String> entry : request.getParams().entrySet()) {
                    requestBuilder.addParameter(entry.getKey(), entry.getValue());
                }
            }
            requestBuilder.setConfig(config).setHeader("User-Agent", crawler.getUserAgent());
        }
        return requestBuilder;
    }
}

