/*
 * Decompiled with CFR 0.152.
 */
package cn.wanghaomiao.seimi.core;

import cn.wanghaomiao.seimi.core.SeimiContext;
import cn.wanghaomiao.seimi.core.SeimiQueue;
import cn.wanghaomiao.seimi.http.HttpMethod;
import cn.wanghaomiao.seimi.httpd.CrawlerStatusHttpProcessor;
import cn.wanghaomiao.seimi.httpd.PushRequestHttpProcessor;
import cn.wanghaomiao.seimi.httpd.SeimiHttpHandler;
import cn.wanghaomiao.seimi.struct.CrawlerModel;
import cn.wanghaomiao.seimi.struct.Request;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;

public class Seimi
extends SeimiContext {
    public void start(String ... crawlerNames) {
        if (crawlerNames == null || crawlerNames.length == 0) {
            for (Map.Entry entry : this.crawlerModelContext.entrySet()) {
                this.sendRequest((String)entry.getKey(), ((CrawlerModel)entry.getValue()).getQueueInstance(), ((CrawlerModel)entry.getValue()).getInstance().startUrls());
            }
        } else {
            for (String name : crawlerNames) {
                CrawlerModel crawlerModel = (CrawlerModel)this.crawlerModelContext.get(name);
                if (crawlerModel != null) {
                    this.sendRequest(crawlerModel.getCrawlerName(), crawlerModel.getQueueInstance(), crawlerModel.getInstance().startUrls());
                    continue;
                }
                this.logger.error("error crawler name '{}',can not find it!", (Object)name);
            }
        }
    }

    public void startWithHttpd(int port, String ... crawlerNames) {
        this.start(crawlerNames);
        SeimiHttpHandler seimiHttpHandler = new SeimiHttpHandler(this.crawlerModelContext);
        if (crawlerNames == null || crawlerNames.length == 0) {
            for (Map.Entry entry : this.crawlerModelContext.entrySet()) {
                seimiHttpHandler.add("/push/" + (String)entry.getKey(), new PushRequestHttpProcessor(((CrawlerModel)entry.getValue()).getQueueInstance(), (String)entry.getKey())).add("/status/" + (String)entry.getKey(), new CrawlerStatusHttpProcessor(((CrawlerModel)entry.getValue()).getQueueInstance(), (String)entry.getKey()));
            }
        } else {
            for (String name : crawlerNames) {
                CrawlerModel crawlerModel = (CrawlerModel)this.crawlerModelContext.get(name);
                if (crawlerModel == null) continue;
                seimiHttpHandler.add("/push/" + name, new PushRequestHttpProcessor(crawlerModel.getQueueInstance(), name)).add("/status/" + name, new CrawlerStatusHttpProcessor(crawlerModel.getQueueInstance(), name));
            }
        }
        this.logger.info("Http request push service also started on port:{}", (Object)port);
        this.startJetty(port, seimiHttpHandler);
    }

    public void startAll() {
        this.start();
    }

    public void startAllWithHttpd(int port) {
        this.startWithHttpd(port, new String[0]);
    }

    public void startWorkers() {
        this.logger.info("workers started!");
    }

    private void sendRequest(String crawlerName, SeimiQueue queue, String[] startUrls) {
        if (ArrayUtils.isNotEmpty((Object[])startUrls)) {
            for (String url : startUrls) {
                Request request = new Request();
                String[] urlPies = url.split("##");
                if (urlPies.length >= 2 && StringUtils.lowerCase((String)urlPies[1]).equals("post")) {
                    request.setHttpMethod(HttpMethod.POST);
                }
                request.setCrawlerName(crawlerName);
                request.setUrl(url);
                request.setCallBack("start");
                queue.push(request);
                this.logger.info("{} url={} started", (Object)crawlerName, (Object)url);
            }
        } else {
            this.logger.error("crawler:{} can not find start urls!", (Object)crawlerName);
        }
    }

    private void startJetty(int port, SeimiHttpHandler seimiHttpHandler) {
        Server server = new Server(port);
        server.setHandler((Handler)seimiHttpHandler);
        try {
            server.start();
            server.join();
        }
        catch (Exception e) {
            this.logger.error("http service start error,{}", (Object)e.getMessage(), (Object)e);
        }
    }
}

