/*
 * Decompiled with CFR 0.152.
 */
package cn.wanghaomiao.seimi.http.hc;

import cn.wanghaomiao.seimi.def.BaseSeimiCrawler;
import cn.wanghaomiao.seimi.exception.SeimiProcessExcepiton;
import cn.wanghaomiao.seimi.http.HttpMethod;
import cn.wanghaomiao.seimi.http.SeimiAgentContentType;
import cn.wanghaomiao.seimi.struct.CrawlerModel;
import cn.wanghaomiao.seimi.struct.Request;
import com.alibaba.fastjson.JSON;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.RequestBuilder;

public class HcRequestGenerator {
    public static RequestBuilder getHttpRequestBuilder(Request request, CrawlerModel crawlerModel) {
        RequestBuilder requestBuilder;
        BaseSeimiCrawler crawler = crawlerModel.getInstance();
        if (request.isUseSeimiAgent()) {
            if (StringUtils.isBlank((CharSequence)crawler.seimiAgentHost())) {
                throw new SeimiProcessExcepiton("SeimiAgentHost is blank.");
            }
            String seimiAgentUrl = "http://" + crawler.seimiAgentHost() + (crawler.seimiAgentPort() != 80 ? ":" + crawler.seimiAgentPort() : "") + "/doload";
            requestBuilder = RequestBuilder.post().setUri(seimiAgentUrl);
            requestBuilder.addParameter("url", request.getUrl());
            if (StringUtils.isNotBlank((CharSequence)crawler.proxy())) {
                requestBuilder.addParameter("proxy", crawler.proxy());
            }
            if (request.getSeimiAgentRenderTime() > 0L) {
                requestBuilder.addParameter("renderTime", String.valueOf(request.getSeimiAgentRenderTime()));
            }
            if (StringUtils.isNotBlank((CharSequence)request.getSeimiAgentScript())) {
                requestBuilder.addParameter("script", request.getSeimiAgentScript());
            }
            if (request.isSeimiAgentUseCookie() == null && crawlerModel.isUseCookie() || request.isSeimiAgentUseCookie() != null && request.isSeimiAgentUseCookie().booleanValue()) {
                requestBuilder.addParameter("useCookie", "1");
            }
            if (request.getParams() != null && request.getParams().size() > 0) {
                requestBuilder.addParameter("postParam", JSON.toJSONString(request.getParams()));
            }
            if (request.getSeimiAgentContentType().val() > SeimiAgentContentType.HTML.val()) {
                requestBuilder.addParameter("contentType", request.getSeimiAgentContentType().typeVal());
            }
        } else {
            requestBuilder = HttpMethod.POST.equals((Object)request.getHttpMethod()) ? RequestBuilder.post().setUri(request.getUrl()) : RequestBuilder.get().setUri(request.getUrl());
            RequestConfig config = RequestConfig.custom().setProxy(crawlerModel.getProxy()).setCircularRedirectsAllowed(true).build();
            if (request.getParams() != null) {
                for (Map.Entry<String, String> entry : request.getParams().entrySet()) {
                    requestBuilder.addParameter(entry.getKey(), entry.getValue());
                }
            }
            requestBuilder.setConfig(config).setHeader("User-Agent", crawlerModel.isUseCookie() ? crawlerModel.getCurrentUA() : crawler.getUserAgent());
            requestBuilder.setHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8");
            requestBuilder.setHeader("Accept-Language", "zh-CN,zh;q=0.8,en;q=0.6");
        }
        return requestBuilder;
    }
}

