/*
 * Decompiled with CFR 0.152.
 */
package cn.wanghaomiao.seimi.core;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public class SeimiScanner {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String RESOURCE_PATTERN = "**/%s/**/*.class";
    private ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
    private AnnotationConfigApplicationContext context;

    public SeimiScanner(AnnotationConfigApplicationContext context) {
        this.context = context;
    }

    @SafeVarargs
    public final Set<Class<?>> scan(String[] confPkgs, Class<? extends Annotation> ... annotationTags) {
        HashSet resClazzSet = new HashSet();
        LinkedList<AnnotationTypeFilter> typeFilters = new LinkedList<AnnotationTypeFilter>();
        if (ArrayUtils.isNotEmpty((Object[])annotationTags)) {
            for (Class<? extends Annotation> annotation : annotationTags) {
                typeFilters.add(new AnnotationTypeFilter((Class)annotation, false));
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])confPkgs)) {
            for (String pkg : confPkgs) {
                String pattern = "classpath*:" + String.format(RESOURCE_PATTERN, ClassUtils.convertClassNameToResourcePath((String)pkg));
                try {
                    Resource[] resources = this.resourcePatternResolver.getResources(pattern);
                    CachingMetadataReaderFactory readerFactory = new CachingMetadataReaderFactory((ResourceLoader)this.resourcePatternResolver);
                    for (Resource resource : resources) {
                        if (!resource.isReadable()) continue;
                        MetadataReader reader = readerFactory.getMetadataReader(resource);
                        String className = reader.getClassMetadata().getClassName();
                        if (!this.ifMatchesEntityType(reader, (MetadataReaderFactory)readerFactory, typeFilters)) continue;
                        Class<?> curClass = Thread.currentThread().getContextClassLoader().loadClass(className);
                        resClazzSet.add(curClass);
                    }
                }
                catch (Exception e) {
                    this.logger.error("\u626b\u63cf\u63d0\u53d6[{}]\u5305\u8def\u5f84\u4e0b\uff0c\u6807\u8bb0\u4e86\u6ce8\u89e3[{}]\u7684\u7c7b\u51fa\u73b0\u5f02\u5e38", (Object)pattern, (Object)StringUtils.join(typeFilters, (String)","));
                }
            }
        }
        return resClazzSet;
    }

    public void regist(List<Class<?>> classList) {
        for (Class<?> cls : classList) {
            this.context.register(new Class[]{cls});
        }
        if (!this.context.isActive()) {
            this.context.refresh();
        }
    }

    private boolean ifMatchesEntityType(MetadataReader reader, MetadataReaderFactory readerFactory, List<AnnotationTypeFilter> typeFilters) {
        if (!CollectionUtils.isEmpty(typeFilters)) {
            for (TypeFilter typeFilter : typeFilters) {
                try {
                    if (!typeFilter.match(reader, readerFactory)) continue;
                    return true;
                }
                catch (IOException e) {
                    this.logger.error("\u8fc7\u6ee4\u5339\u914d\u7c7b\u578b\u65f6\u51fa\u9519 {}", (Object)e.getMessage());
                }
            }
        }
        return false;
    }
}

