/*
 * Decompiled with CFR 0.152.
 */
package cn.wanghaomiao.seimi.core;

import cn.wanghaomiao.seimi.annotation.Xpath;
import cn.wanghaomiao.seimi.exception.SeimiBeanResolveException;
import cn.wanghaomiao.seimi.utils.GenericUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.nodes.Element;
import org.seimicrawler.xpath.JXDocument;
import org.springframework.util.ReflectionUtils;

public class SeimiBeanResolver {
    public static <T> T parse(Class<T> target, String text) throws Exception {
        T bean = target.newInstance();
        final LinkedList props = new LinkedList();
        ReflectionUtils.doWithFields(target, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                props.add(field);
            }
        });
        JXDocument jxDocument = JXDocument.create((String)text);
        for (Field f : props) {
            Xpath xpathInfo = f.getAnnotation(Xpath.class);
            if (xpathInfo == null) continue;
            String xpath = xpathInfo.value();
            List res = jxDocument.sel(xpath);
            boolean accessFlag = f.isAccessible();
            f.setAccessible(true);
            f.set(bean, SeimiBeanResolver.defaultCastToTargetValue(target, f, res));
            f.setAccessible(accessFlag);
        }
        return bean;
    }

    private static String upperFirst(String str) {
        return str != null ? str.substring(0, 1).toUpperCase() + str.substring(1) : null;
    }

    private static Object defaultCastToTargetValue(Class target, Field field, List<Object> xpathRes) {
        Method getter = ReflectionUtils.findMethod((Class)target, (String)("get" + SeimiBeanResolver.upperFirst(field.getName())));
        if (getter != null) {
            if (List.class.equals(getter.getReturnType())) {
                Class<?>[] componentClazzs = GenericUtils.getActualClass(getter.getGenericReturnType());
                if (componentClazzs != null && componentClazzs.length > 0) {
                    Class<?> componentClass = componentClazzs[0];
                    if (String.class.isAssignableFrom(componentClass)) {
                        LinkedList<String> resTmp = new LinkedList<String>();
                        for (Object obj : xpathRes) {
                            if (obj instanceof Element) {
                                resTmp.add(((Element)obj).html());
                                continue;
                            }
                            resTmp.add(obj.toString());
                        }
                        return resTmp;
                    }
                    if (Element.class.isAssignableFrom(componentClass)) {
                        return xpathRes;
                    }
                    if (GenericUtils.isNumber(componentClass)) {
                        LinkedList<Object> resTmp = new LinkedList<Object>();
                        for (Object obj : xpathRes) {
                            resTmp.add(GenericUtils.castToNumber(componentClass, obj.toString()));
                        }
                        return resTmp;
                    }
                    throw new SeimiBeanResolveException("not support field type");
                }
            } else {
                if (!Collection.class.isAssignableFrom(getter.getReturnType()) && getter.getReturnType().isArray()) {
                    Class<?> componentClass = getter.getReturnType().getComponentType();
                    if (String.class.isAssignableFrom(componentClass)) {
                        LinkedList<String> resTmp = new LinkedList<String>();
                        for (Object obj : xpathRes) {
                            if (obj instanceof Element) {
                                resTmp.add(((Element)obj).html());
                                continue;
                            }
                            resTmp.add(obj.toString());
                        }
                        return resTmp;
                    }
                    if (Element.class.isAssignableFrom(componentClass)) {
                        return xpathRes;
                    }
                    if (GenericUtils.isNumber(componentClass)) {
                        LinkedList<Object> resTmp = new LinkedList<Object>();
                        for (Object obj : xpathRes) {
                            resTmp.add(GenericUtils.castToNumber(componentClass, obj.toString()));
                        }
                        return resTmp;
                    }
                    throw new SeimiBeanResolveException("not support field type");
                }
                if (!Collection.class.isAssignableFrom(getter.getReturnType()) && GenericUtils.isNumber(field.getType())) {
                    return GenericUtils.castToNumber(field.getType(), StringUtils.join(xpathRes, (String)""));
                }
                if (!Collection.class.isAssignableFrom(getter.getReturnType()) && String.class.isAssignableFrom(field.getType())) {
                    return StringUtils.join(xpathRes, (String)"");
                }
            }
        }
        return null;
    }
}

