/*
 * Decompiled with CFR 0.152.
 */
package cn.wanghaomiao.seimi.spring.common;

import cn.wanghaomiao.seimi.annotation.Crawler;
import cn.wanghaomiao.seimi.annotation.Interceptor;
import cn.wanghaomiao.seimi.core.SeimiInterceptor;
import cn.wanghaomiao.seimi.def.BaseSeimiCrawler;
import cn.wanghaomiao.seimi.spring.common.CrawlerCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class SeimiCrawlerBeanPostProcessor
implements BeanPostProcessor {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Interceptor interceptor;
        Class<?> beanClass = bean.getClass();
        Crawler crawler = beanClass.getAnnotation(Crawler.class);
        if (crawler != null) {
            if (BaseSeimiCrawler.class.isAssignableFrom(beanClass)) {
                CrawlerCache.addCrawler(beanClass);
            } else {
                this.logger.error("Crawler={} not extends {@link cn.wanghaomiao.seimi.def.BaseSeimiCrawler}", (Object)beanClass.getName());
            }
        }
        if ((interceptor = beanClass.getAnnotation(Interceptor.class)) != null) {
            if (SeimiInterceptor.class.isAssignableFrom(beanClass)) {
                CrawlerCache.addInterceptor((SeimiInterceptor)bean);
            } else {
                this.logger.error("find class = {}, has @Interceptor but not implement cn.wanghaomiao.seimi.core.SeimiInterceptor", (Object)beanClass.getName());
            }
        }
        return bean;
    }
}

