/*
 * Decompiled with CFR 0.152.
 */
package cn.wanghaomiao.seimi.http.hc;

import cn.wanghaomiao.seimi.core.SeimiDownloader;
import cn.wanghaomiao.seimi.http.SeimiCookie;
import cn.wanghaomiao.seimi.http.SeimiHttpType;
import cn.wanghaomiao.seimi.http.hc.HcRequestGenerator;
import cn.wanghaomiao.seimi.http.hc.HttpClientFactory;
import cn.wanghaomiao.seimi.struct.BodyType;
import cn.wanghaomiao.seimi.struct.CrawlerModel;
import cn.wanghaomiao.seimi.struct.Request;
import cn.wanghaomiao.seimi.struct.Response;
import cn.wanghaomiao.seimi.utils.StrFormatUtil;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.seimicrawler.xpath.JXDocument;
import org.seimicrawler.xpath.exception.NoSuchAxisException;
import org.seimicrawler.xpath.exception.NoSuchFunctionException;
import org.seimicrawler.xpath.exception.XpathSyntaxErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HcDownloader
implements SeimiDownloader {
    private CrawlerModel crawlerModel;
    private HttpClient hc;
    private RequestBuilder currentReqBuilder;
    private Request currentRequest;
    private HttpResponse httpResponse;
    private HttpContext httpContext = new BasicHttpContext();
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public HcDownloader(CrawlerModel crawlerModel) {
        this.crawlerModel = crawlerModel;
        this.hc = crawlerModel.isUseCookie() ? HttpClientFactory.getHttpClient(crawlerModel.getHttpTimeOut(), crawlerModel.getCookieStore()) : HttpClientFactory.getHttpClient(crawlerModel.getHttpTimeOut());
    }

    @Override
    public Response process(Request request) throws Exception {
        this.currentReqBuilder = HcRequestGenerator.getHttpRequestBuilder(request, this.crawlerModel);
        this.currentRequest = request;
        this.addCookies(request.getUrl(), request.getSeimiCookies());
        this.httpResponse = this.hc.execute(this.currentReqBuilder.build(), this.httpContext);
        return this.renderResponse(this.httpResponse, request, this.httpContext);
    }

    @Override
    public Response metaRefresh(String nextUrl) throws Exception {
        if (!nextUrl.startsWith("http")) {
            String prefix = this.getRealUrl(this.httpContext);
            nextUrl = prefix + nextUrl;
        }
        this.logger.info("Seimi refresh url to={} from={}", (Object)nextUrl, (Object)this.currentReqBuilder.getUri());
        this.currentReqBuilder.setUri(nextUrl);
        this.httpResponse = this.hc.execute(this.currentReqBuilder.build(), this.httpContext);
        return this.renderResponse(this.httpResponse, this.currentRequest, this.httpContext);
    }

    @Override
    public int statusCode() {
        return this.httpResponse.getStatusLine().getStatusCode();
    }

    @Override
    public void addCookies(String url, List<SeimiCookie> seimiCookies) {
        if (seimiCookies == null || seimiCookies.size() <= 0) {
            return;
        }
        CookieStore cookieStore = this.crawlerModel.getCookieStore();
        for (SeimiCookie seimiCookie : seimiCookies) {
            BasicClientCookie cookie = new BasicClientCookie(seimiCookie.getName(), seimiCookie.getValue());
            cookie.setPath(StringUtils.isNotBlank((CharSequence)seimiCookie.getPath()) ? seimiCookie.getPath() : "/");
            cookie.setDomain(StringUtils.isNotBlank((CharSequence)seimiCookie.getDomain()) ? seimiCookie.getDomain() : StrFormatUtil.getDodmain(url));
            cookieStore.addCookie((Cookie)cookie);
        }
    }

    private Response renderResponse(HttpResponse httpResponse, Request request, HttpContext httpContext) {
        Response seimiResponse;
        block9: {
            seimiResponse = new Response();
            HttpEntity entity = httpResponse.getEntity();
            seimiResponse.setSeimiHttpType(SeimiHttpType.APACHE_HC);
            seimiResponse.setRealUrl(this.getRealUrl(httpContext));
            seimiResponse.setUrl(request.getUrl());
            seimiResponse.setRequest(request);
            seimiResponse.setMeta(request.getMeta());
            if (entity != null) {
                String contentTypeStr;
                Header referer = httpResponse.getFirstHeader("Referer");
                if (referer != null) {
                    seimiResponse.setReferer(referer.getValue());
                }
                if ((contentTypeStr = entity.getContentType().getValue().toLowerCase()).contains("text") || contentTypeStr.contains("json") || contentTypeStr.contains("ajax")) {
                    seimiResponse.setBodyType(BodyType.TEXT);
                    try {
                        seimiResponse.setData(EntityUtils.toByteArray((HttpEntity)entity));
                        ContentType contentType = ContentType.get((HttpEntity)entity);
                        Charset charset = contentType.getCharset();
                        if (charset == null) {
                            seimiResponse.setContent(new String(seimiResponse.getData(), "ISO-8859-1"));
                            String docCharset = this.renderRealCharset(seimiResponse);
                            seimiResponse.setContent(new String(seimiResponse.getContent().getBytes("ISO-8859-1"), docCharset));
                            seimiResponse.setCharset(docCharset);
                            break block9;
                        }
                        seimiResponse.setContent(new String(seimiResponse.getData(), charset));
                        seimiResponse.setCharset(charset.name());
                    }
                    catch (Exception e) {
                        this.logger.error("no content data");
                    }
                } else {
                    seimiResponse.setBodyType(BodyType.BINARY);
                    try {
                        seimiResponse.setData(EntityUtils.toByteArray((HttpEntity)entity));
                        seimiResponse.setContent(StringUtils.substringAfterLast((String)request.getUrl(), (String)"/"));
                    }
                    catch (Exception e) {
                        this.logger.error("no data can be read from httpResponse");
                    }
                }
            }
        }
        return seimiResponse;
    }

    private String renderRealCharset(Response response) throws NoSuchFunctionException, XpathSyntaxErrorException, NoSuchAxisException {
        JXDocument doc = response.document();
        String charset = StrFormatUtil.getFirstEmStr(doc.sel("//meta[@charset]/@charset"), "").trim();
        if (StringUtils.isBlank((CharSequence)charset)) {
            charset = StrFormatUtil.getFirstEmStr(doc.sel("//meta[@http-equiv='charset']/@content"), "").trim();
        }
        if (StringUtils.isBlank((CharSequence)charset)) {
            String ct = StringUtils.join((Iterable)doc.sel("//meta[@http-equiv='Content-Type']/@content|//meta[@http-equiv='content-type']/@content"), (String)";").trim();
            charset = StrFormatUtil.parseCharset(ct.toLowerCase());
        }
        return StringUtils.isNotBlank((CharSequence)charset) ? charset : "UTF-8";
    }

    private String getRealUrl(HttpContext httpContext) {
        Object target = httpContext.getAttribute("http.target_host");
        Object reqUri = httpContext.getAttribute("http.request");
        if (target == null || reqUri == null) {
            return null;
        }
        HttpHost t = (HttpHost)target;
        HttpUriRequest r = (HttpUriRequest)reqUri;
        return r.getURI().isAbsolute() ? r.getURI().toString() : t.toString() + r.getURI().toString();
    }
}

