/*
 * Decompiled with CFR 0.152.
 */
package cn.wanghaomiao.seimi.struct;

import cn.wanghaomiao.seimi.annotation.Xpath;
import cn.wanghaomiao.seimi.exception.SeimiBeanResolveException;
import cn.wanghaomiao.seimi.exception.SeimiProcessExcepiton;
import cn.wanghaomiao.seimi.http.SeimiHttpType;
import cn.wanghaomiao.seimi.struct.BodyType;
import cn.wanghaomiao.seimi.struct.CommonObject;
import cn.wanghaomiao.seimi.struct.Request;
import cn.wanghaomiao.seimi.utils.GenericUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.nodes.Element;
import org.seimicrawler.xpath.JXDocument;
import org.springframework.util.ReflectionUtils;

public class Response
extends CommonObject {
    private BodyType bodyType;
    private Request request;
    private String charset;
    private String referer;
    private byte[] data;
    private String content;
    private Map<String, Object> meta;
    private String url;
    private Map<String, String> params;
    private String realUrl;
    private SeimiHttpType seimiHttpType;

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public BodyType getBodyType() {
        return this.bodyType;
    }

    public void setBodyType(BodyType bodyType) {
        this.bodyType = bodyType;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Map<String, Object> getMeta() {
        return this.meta;
    }

    public void setMeta(Map<String, Object> meta) {
        this.meta = meta;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public String getReferer() {
        return this.referer;
    }

    public void setReferer(String referer) {
        this.referer = referer;
    }

    public String getRealUrl() {
        return this.realUrl;
    }

    public void setRealUrl(String realUrl) {
        this.realUrl = realUrl;
    }

    public SeimiHttpType getSeimiHttpType() {
        return this.seimiHttpType;
    }

    public void setSeimiHttpType(SeimiHttpType seimiHttpType) {
        this.seimiHttpType = seimiHttpType;
    }

    public <T> T render(Class<T> bean) throws Exception {
        if (this.bodyType.equals((Object)BodyType.TEXT)) {
            return this.parse(bean, this.content);
        }
        throw new SeimiProcessExcepiton("can not parse struct from binary");
    }

    public JXDocument document() {
        return BodyType.TEXT.equals((Object)this.bodyType) && this.content != null ? JXDocument.create((String)this.content) : null;
    }

    public void saveTo(File targetFile) {
        try (FileOutputStream fileOutputStream = new FileOutputStream(targetFile);
             FileChannel fo = fileOutputStream.getChannel();){
            File pf = targetFile.getParentFile();
            if (!pf.exists()) {
                pf.mkdirs();
            }
            if (BodyType.TEXT.equals((Object)this.bodyType)) {
                fo.write(ByteBuffer.wrap(this.getContent().getBytes()));
            } else {
                fo.write(ByteBuffer.wrap(this.getData()));
            }
        }
        catch (Exception e) {
            throw new SeimiProcessExcepiton(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T parse(Class<T> target, String text) throws Exception {
        T bean = target.newInstance();
        LinkedList props = new LinkedList();
        ReflectionUtils.doWithFields(target, props::add);
        JXDocument jxDocument = JXDocument.create((String)text);
        for (Field f : props) {
            Xpath xpathInfo = f.getAnnotation(Xpath.class);
            if (xpathInfo == null) continue;
            String xpath = xpathInfo.value();
            List res = jxDocument.sel(xpath);
            Field field = f;
            synchronized (field) {
                boolean accessFlag = f.isAccessible();
                f.setAccessible(true);
                f.set(bean, this.defaultCastToTargetValue(target, f, res));
                f.setAccessible(accessFlag);
            }
        }
        return bean;
    }

    private String upperFirst(String str) {
        return str != null ? str.substring(0, 1).toUpperCase() + str.substring(1) : null;
    }

    private Object defaultCastToTargetValue(Class target, Field field, List<Object> xpathRes) {
        Method getter = ReflectionUtils.findMethod((Class)target, (String)("get" + this.upperFirst(field.getName())));
        if (getter != null) {
            if (List.class.equals(getter.getReturnType())) {
                Class<?>[] componentClazzs = GenericUtils.getActualClass(getter.getGenericReturnType());
                if (componentClazzs != null && componentClazzs.length > 0) {
                    Class<?> componentClass = componentClazzs[0];
                    return this.getObject(xpathRes, componentClass);
                }
            } else {
                if (!Collection.class.isAssignableFrom(getter.getReturnType()) && getter.getReturnType().isArray()) {
                    Class<?> componentClass = getter.getReturnType().getComponentType();
                    return this.getObject(xpathRes, componentClass);
                }
                if (!Collection.class.isAssignableFrom(getter.getReturnType()) && GenericUtils.isNumber(field.getType())) {
                    return GenericUtils.castToNumber(field.getType(), StringUtils.join(xpathRes, (String)""));
                }
                if (!Collection.class.isAssignableFrom(getter.getReturnType()) && String.class.isAssignableFrom(field.getType())) {
                    return StringUtils.join(xpathRes, (String)"");
                }
            }
        }
        return null;
    }

    private Object getObject(List<Object> xpathRes, Class componentClass) {
        if (String.class.isAssignableFrom(componentClass)) {
            LinkedList<String> resTmp = new LinkedList<String>();
            for (Object obj : xpathRes) {
                if (obj instanceof Element) {
                    resTmp.add(((Element)obj).html());
                    continue;
                }
                resTmp.add(obj.toString());
            }
            return resTmp;
        }
        if (Element.class.isAssignableFrom(componentClass)) {
            return xpathRes;
        }
        if (GenericUtils.isNumber(componentClass)) {
            LinkedList<Object> resTmp = new LinkedList<Object>();
            for (Object obj : xpathRes) {
                resTmp.add(GenericUtils.castToNumber(componentClass, obj.toString()));
            }
            return resTmp;
        }
        throw new SeimiBeanResolveException("not support field type");
    }
}

