/*
 * Decompiled with CFR 0.152.
 */
package cn.wanghaomiao.seimi.boot;

import cn.wanghaomiao.seimi.core.Seimi;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class Run {
    static final Option HTTPD_PORT = new Option("p", "port", true, "Port number of API server");
    static final Option CRAWLER_NAMES = new Option("c", "crawler_names", true, "which crawler will start interface and split with comma.");
    static final Option HELP_OPT = new Option("h", "help", false, "Show this help and quit");
    private String[] crawlers;
    private Integer port;

    public int run(String[] args) {
        try {
            this.parseOptions(args);
        }
        catch (IllegalStateException e) {
            this.printHelpAndExit(e.getMessage(), this.getOptions());
        }
        return this.startHttpd();
    }

    private int startHttpd() {
        try {
            Seimi s = new Seimi();
            if (this.port != null) {
                s.goRunWithHttpd(this.port, this.crawlers);
            } else {
                s.goRun(true, this.crawlers);
            }
        }
        catch (Exception e) {
            return -1;
        }
        return 1;
    }

    private void parseOptions(String[] args) {
        Options options = this.getOptions();
        PosixParser parser = new PosixParser();
        CommandLine cmdLine = null;
        try {
            cmdLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            this.printHelpAndExit("Error parsing command line options: " + e.getMessage(), options);
        }
        assert (cmdLine != null);
        if (cmdLine.hasOption(HELP_OPT.getOpt())) {
            this.printHelpAndExit(options, 0);
        }
        if (cmdLine.hasOption(HTTPD_PORT.getOpt())) {
            String portValue = cmdLine.getOptionValue(HTTPD_PORT.getOpt());
            if (portValue.matches("\\d+")) {
                this.port = Integer.parseInt(portValue);
            } else {
                throw new IllegalArgumentException("port must be number: " + portValue);
            }
        }
        if (!cmdLine.getArgList().isEmpty()) {
            throw new IllegalStateException("Got unexpected extra parameters: " + cmdLine.getArgList());
        }
        if (cmdLine.hasOption(CRAWLER_NAMES.getOpt())) {
            String crawlerNames = cmdLine.getOptionValue(CRAWLER_NAMES.getOpt());
            this.crawlers = crawlerNames.split(",");
        }
    }

    public static void main(String[] args) {
        int run = new Run().run(args);
        System.exit(run);
    }

    private Options getOptions() {
        Options options = new Options();
        options.addOption(HTTPD_PORT);
        options.addOption(CRAWLER_NAMES);
        options.addOption(HELP_OPT);
        return options;
    }

    private void printHelpAndExit(String errorMessage, Options options) {
        System.err.println(errorMessage);
        this.printHelpAndExit(options, 1);
    }

    private void printHelpAndExit(Options options, int exitCode) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("help\nIf null of crawlers it will be start all crawlers interface.\nIf port of httpd is null,it will be just start all crawler with out API server.\nIf both of args are null,it will be just start a agent waiting for queue order.", options);
        System.exit(exitCode);
    }
}

