/*
 * Decompiled with CFR 0.152.
 */
package cn.wanghaomiao.seimi.config;

import org.redisson.client.codec.Codec;
import org.redisson.codec.FstCodec;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.ReplicatedServersConfig;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;

public class SeimiConfig {
    private boolean enableRedissonQueue = false;
    private long bloomFilterExpectedInsertions;
    private double bloomFilterFalseProbability;
    private String seimiAgentHost;
    private int seimiAgentPort = 80;
    private Config redissonConfig;

    public SeimiConfig() {
        this.redissonConfig = new Config();
    }

    public SeimiConfig(Config config) {
        this.enableRedissonQueue = true;
        this.redissonConfig = config;
        this.redissonConfig.setCodec((Codec)new FstCodec());
    }

    public boolean isEnableRedissonQueue() {
        return this.enableRedissonQueue;
    }

    public SeimiConfig enableDistributedQueue() {
        this.enableRedissonQueue = true;
        return this;
    }

    public MasterSlaveServersConfig redisMasterSlaveServers() {
        this.enableDistributedQueue();
        return this.redissonConfig.useMasterSlaveServers();
    }

    public SentinelServersConfig redisSentinelServers() {
        this.enableDistributedQueue();
        return this.redissonConfig.useSentinelServers();
    }

    public SingleServerConfig redisSingleServer() {
        this.enableDistributedQueue();
        return this.redissonConfig.useSingleServer();
    }

    public ReplicatedServersConfig redisReplicatedServers() {
        this.enableDistributedQueue();
        return this.redissonConfig.useReplicatedServers();
    }

    public ClusterServersConfig redisClusterServers() {
        this.enableDistributedQueue();
        return this.redissonConfig.useClusterServers();
    }

    public long getBloomFilterExpectedInsertions() {
        return this.bloomFilterExpectedInsertions;
    }

    public void setBloomFilterExpectedInsertions(long bloomFilterExpectedInsertions) {
        this.bloomFilterExpectedInsertions = bloomFilterExpectedInsertions;
    }

    public double getBloomFilterFalseProbability() {
        return this.bloomFilterFalseProbability;
    }

    public void setBloomFilterFalseProbability(double bloomFilterFalseProbability) {
        this.bloomFilterFalseProbability = bloomFilterFalseProbability;
    }

    public String getSeimiAgentHost() {
        return this.seimiAgentHost;
    }

    public void setSeimiAgentHost(String seimiAgentHost) {
        this.seimiAgentHost = seimiAgentHost;
    }

    public int getSeimiAgentPort() {
        return this.seimiAgentPort;
    }

    public void setSeimiAgentPort(int seimiAgentPort) {
        this.seimiAgentPort = seimiAgentPort;
    }

    public Config getRedissonConfig() {
        return this.redissonConfig;
    }
}

