/*
 * Decompiled with CFR 0.152.
 */
package cn.wanghaomiao.seimi.core;

import cn.wanghaomiao.seimi.annotation.Interceptor;
import cn.wanghaomiao.seimi.core.SeimiDownloader;
import cn.wanghaomiao.seimi.core.SeimiInterceptor;
import cn.wanghaomiao.seimi.core.SeimiQueue;
import cn.wanghaomiao.seimi.def.BaseSeimiCrawler;
import cn.wanghaomiao.seimi.http.SeimiHttpType;
import cn.wanghaomiao.seimi.http.hc.HcDownloader;
import cn.wanghaomiao.seimi.http.okhttp.OkHttpDownloader;
import cn.wanghaomiao.seimi.struct.BodyType;
import cn.wanghaomiao.seimi.struct.CrawlerModel;
import cn.wanghaomiao.seimi.struct.Request;
import cn.wanghaomiao.seimi.struct.Response;
import cn.wanghaomiao.seimi.utils.StructValidator;
import com.alibaba.fastjson.JSON;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeimiProcessor
implements Runnable {
    private SeimiQueue queue;
    private List<SeimiInterceptor> interceptors;
    private CrawlerModel crawlerModel;
    private BaseSeimiCrawler crawler;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Pattern metaRefresh = Pattern.compile("<(?:META|meta|Meta)\\s+(?:HTTP-EQUIV|http-equiv)\\s*=\\s*\"refresh\".*(?:url|URL)=(\\S*)\".*/?>");

    public SeimiProcessor(List<SeimiInterceptor> interceptors, CrawlerModel crawlerModel) {
        this.queue = crawlerModel.getQueueInstance();
        this.interceptors = interceptors;
        this.crawlerModel = crawlerModel;
        this.crawler = crawlerModel.getInstance();
    }

    @Override
    public void run() {
        while (true) {
            Request request = null;
            try {
                request = this.queue.bPop(this.crawlerModel.getCrawlerName());
                if (request == null) continue;
                if (this.crawlerModel == null) {
                    this.logger.error("No such crawler name:'{}'", (Object)request.getCrawlerName());
                    continue;
                }
                if (request.isStop()) {
                    this.logger.info("SeimiProcessor[{}] will stop!", (Object)Thread.currentThread().getName());
                    break;
                }
                if (!StructValidator.validateAnno(request)) {
                    this.logger.warn("Request={} is illegal", (Object)JSON.toJSONString((Object)request));
                    continue;
                }
                if (!StructValidator.validateAllowRules(this.crawler.allowRules(), request.getUrl())) {
                    this.logger.warn("Request={} will be dropped by allowRules=[{}]", (Object)JSON.toJSONString((Object)request), (Object)StringUtils.join((Object[])this.crawler.allowRules(), (String)","));
                    continue;
                }
                if (StructValidator.validateDenyRules(this.crawler.denyRules(), request.getUrl())) {
                    this.logger.warn("Request={} will be dropped by denyRules=[{}]", (Object)JSON.toJSONString((Object)request), (Object)StringUtils.join((Object[])this.crawler.denyRules(), (String)","));
                    continue;
                }
                if (request.getCurrentReqCount() >= request.getMaxReqCount() + 3) continue;
                SeimiDownloader downloader = SeimiHttpType.APACHE_HC.val() == this.crawlerModel.getSeimiHttpType().val() ? new HcDownloader(this.crawlerModel) : new OkHttpDownloader(this.crawlerModel);
                Response seimiResponse = downloader.process(request);
                if (StringUtils.isNotBlank((CharSequence)seimiResponse.getContent()) && BodyType.TEXT.equals((Object)seimiResponse.getBodyType())) {
                    Matcher mm = this.metaRefresh.matcher(seimiResponse.getContent());
                    for (int refreshCount = 0; !request.isUseSeimiAgent() && mm.find() && refreshCount < 3; ++refreshCount) {
                        String nextUrl = mm.group(1).replaceAll("'", "");
                        seimiResponse = downloader.metaRefresh(nextUrl);
                        mm = this.metaRefresh.matcher(seimiResponse.getContent());
                    }
                }
                if (!request.isLambdaCb()) {
                    this.doCallback(request, seimiResponse);
                } else {
                    this.doLambdaCallback(request, seimiResponse);
                }
                this.logger.debug("Crawler[{}] ,url={} ,responseStatus={}", new Object[]{this.crawlerModel.getCrawlerName(), request.getUrl(), downloader.statusCode()});
            }
            catch (Throwable e) {
                this.logger.error(e.getMessage(), e);
                if (request == null) continue;
                if (request.getCurrentReqCount() < request.getMaxReqCount()) {
                    request.incrReqCount();
                    this.queue.push(request);
                    this.logger.info("Request process error,req will go into queue again,url={},maxReqCount={},currentReqCount={}", new Object[]{request.getUrl(), request.getMaxReqCount(), request.getCurrentReqCount()});
                    continue;
                }
                if (request.getCurrentReqCount() < request.getMaxReqCount() || request.getMaxReqCount() <= 0) continue;
                this.crawler.handleErrorRequest(request);
            }
        }
    }

    private void doCallback(Request request, Response seimiResponse) throws Exception {
        Interceptor interAnno;
        Method requestCallback = this.crawlerModel.getMemberMethods().get(request.getCallBack());
        if (requestCallback == null) {
            this.logger.info("can not find callback function");
            return;
        }
        for (SeimiInterceptor interceptor : this.interceptors) {
            interAnno = interceptor.getClass().getAnnotation(Interceptor.class);
            if (!interAnno.everyMethod() && !requestCallback.isAnnotationPresent(interceptor.getTargetAnnotationClass()) && !this.crawlerModel.getClazz().isAnnotationPresent(interceptor.getTargetAnnotationClass())) continue;
            interceptor.before(requestCallback, seimiResponse);
        }
        if (this.crawlerModel.getDelay() > 0) {
            TimeUnit.SECONDS.sleep(this.crawlerModel.getDelay());
        }
        requestCallback.invoke((Object)this.crawlerModel.getInstance(), seimiResponse);
        for (SeimiInterceptor interceptor : this.interceptors) {
            interAnno = interceptor.getClass().getAnnotation(Interceptor.class);
            if (!interAnno.everyMethod() && !requestCallback.isAnnotationPresent(interceptor.getTargetAnnotationClass()) && !this.crawlerModel.getClazz().isAnnotationPresent(interceptor.getTargetAnnotationClass())) continue;
            interceptor.after(requestCallback, seimiResponse);
        }
    }

    private void doLambdaCallback(Request request, Response seimiResponse) throws Exception {
        Interceptor interAnno;
        Request.SeimiCallbackFunc requestCallback = request.getCallBackFunc();
        if (requestCallback == null) {
            this.logger.info("can not find callback function");
            return;
        }
        for (SeimiInterceptor interceptor : this.interceptors) {
            interAnno = interceptor.getClass().getAnnotation(Interceptor.class);
            if (!interAnno.everyMethod()) continue;
            interceptor.before(null, seimiResponse);
        }
        if (this.crawlerModel.getDelay() > 0) {
            TimeUnit.SECONDS.sleep(this.crawlerModel.getDelay());
        }
        requestCallback.call(this.crawler, seimiResponse);
        for (SeimiInterceptor interceptor : this.interceptors) {
            interAnno = interceptor.getClass().getAnnotation(Interceptor.class);
            if (!interAnno.everyMethod()) continue;
            interceptor.after(null, seimiResponse);
        }
    }
}

