/*
 * Decompiled with CFR 0.152.
 */
package cn.wanghaomiao.seimi.def;

import cn.wanghaomiao.seimi.annotation.Queue;
import cn.wanghaomiao.seimi.config.SeimiConfig;
import cn.wanghaomiao.seimi.core.SeimiQueue;
import cn.wanghaomiao.seimi.exception.SeimiInitExcepiton;
import cn.wanghaomiao.seimi.spring.boot.CrawlerProperties;
import cn.wanghaomiao.seimi.spring.common.CrawlerCache;
import cn.wanghaomiao.seimi.struct.Request;
import cn.wanghaomiao.seimi.utils.GenericUtils;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.codec.digest.DigestUtils;
import org.redisson.api.RBlockingQueue;
import org.redisson.api.RBloomFilter;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.codec.FstCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Queue
public class DefaultRedisQueue
implements SeimiQueue {
    private String quueNamePrefix = "SEIMI_CRAWLER_QUEUE_";
    private String setNamePrefix = "SEIMI_CRAWLER_SET_";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private long expectedInsertions = 100000000L;
    private double falseProbability = 0.01;
    private Map<String, RBlockingQueue<Request>> queueCache = new HashMap<String, RBlockingQueue<Request>>();
    private Map<String, RBloomFilter<String>> bloomFilterCache = new HashMap<String, RBloomFilter<String>>();
    @Autowired(required=false)
    private CrawlerProperties crawlerProperties;
    @Autowired(required=false)
    private RedissonClient redisson;

    @PostConstruct
    public void init() {
        boolean isEnableRedissonQueue = false;
        if (!CrawlerCache.isSpringBoot()) {
            SeimiConfig seimiConfig = CrawlerCache.getConfig();
            if (seimiConfig != null && seimiConfig.isEnableRedissonQueue()) {
                isEnableRedissonQueue = true;
                if (seimiConfig.getBloomFilterExpectedInsertions() > 0L) {
                    this.expectedInsertions = seimiConfig.getBloomFilterExpectedInsertions();
                }
                if (seimiConfig.getBloomFilterFalseProbability() > 0.0) {
                    this.falseProbability = seimiConfig.getBloomFilterFalseProbability();
                }
            }
        } else if (this.crawlerProperties != null && this.crawlerProperties.isEnableRedissonQueue()) {
            isEnableRedissonQueue = true;
            if (this.crawlerProperties.getBloomFilterExpectedInsertions() > 0L) {
                this.expectedInsertions = this.crawlerProperties.getBloomFilterExpectedInsertions();
            }
            if (this.crawlerProperties.getBloomFilterFalseProbability() > 0.0) {
                this.falseProbability = this.crawlerProperties.getBloomFilterFalseProbability();
            }
        }
        if (isEnableRedissonQueue && this.redisson == null) {
            this.logger.error("");
            throw new SeimiInitExcepiton(" \u68c0\u6d4b\u5230\u542f\u7528\u4e86\u7684 Redison queue\uff0c\u4f46\u662f\u6ca1\u6709\u53d1\u73b0Redisson\u914d\u7f6e\uff0c\u8bf7\u53c2\u8003\uff1ahttps://github.com/redisson/redisson/wiki/2.-%E9%85%8D%E7%BD%AE%E6%96%B9%E6%B3%95");
        }
        this.logger.info("springboot={},isEnableRedissonQueue = {},redisson = {}", new Object[]{CrawlerCache.isSpringBoot(), isEnableRedissonQueue, this.redisson});
    }

    @Override
    public Request bPop(String crawlerName) {
        Request request = null;
        try {
            RBlockingQueue<Request> rBlockingQueue = this.getQueue(crawlerName);
            request = (Request)rBlockingQueue.take();
        }
        catch (Exception e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
        }
        return request;
    }

    @Override
    public boolean push(Request req) {
        try {
            RBlockingQueue<Request> rBlockingQueue = this.getQueue(req.getCrawlerName());
            rBlockingQueue.put((Object)req);
            return true;
        }
        catch (Exception e) {
            this.logger.warn(e.getMessage());
            return false;
        }
    }

    @Override
    public long len(String crawlerName) {
        long len = 0L;
        try {
            RBlockingQueue<Request> rBlockingQueue = this.getQueue(crawlerName);
            len = rBlockingQueue.size();
        }
        catch (Exception e) {
            this.logger.warn(e.getMessage());
        }
        return len;
    }

    @Override
    public boolean isProcessed(Request req) {
        boolean res = false;
        try {
            String sign = GenericUtils.signRequest(req);
            RBloomFilter<String> bloomFilter = this.getFilter(req.getCrawlerName());
            res = bloomFilter.contains((Object)sign);
        }
        catch (Exception e) {
            this.logger.warn(e.getMessage());
        }
        return res;
    }

    @Override
    public void addProcessed(Request req) {
        try {
            String sign = DigestUtils.md5Hex((String)req.getUrl());
            RBloomFilter<String> bloomFilter = this.getFilter(req.getCrawlerName());
            bloomFilter.add((Object)sign);
        }
        catch (Exception e) {
            this.logger.warn(e.getMessage());
        }
    }

    @Override
    public long totalCrawled(String crawlerName) {
        long count = 0L;
        try {
            RBloomFilter<String> bloomFilter = this.getFilter(crawlerName);
            count = bloomFilter.count();
        }
        catch (Exception e) {
            this.logger.warn(e.getMessage());
        }
        return count;
    }

    @Override
    public void clearRecord(String crawlerName) {
        try {
            RBloomFilter<String> bloomFilter = this.getFilter(crawlerName);
            bloomFilter.delete();
        }
        catch (Exception e) {
            this.logger.warn(e.getMessage());
        }
    }

    private RBlockingQueue<Request> getQueue(String crawlerName) {
        RBlockingQueue rBlockingQueue = this.queueCache.get(crawlerName);
        if (rBlockingQueue == null) {
            rBlockingQueue = this.redisson.getBlockingQueue(this.quueNamePrefix + crawlerName, (Codec)new FstCodec());
            this.queueCache.put(crawlerName, (RBlockingQueue<Request>)rBlockingQueue);
        }
        return rBlockingQueue;
    }

    private RBloomFilter<String> getFilter(String crawlerName) {
        RBloomFilter bloomFilter = this.bloomFilterCache.get(crawlerName);
        if (bloomFilter == null) {
            bloomFilter = this.redisson.getBloomFilter(this.setNamePrefix + crawlerName, (Codec)new StringCodec());
            bloomFilter.tryInit(this.expectedInsertions, this.falseProbability);
            this.bloomFilterCache.put(crawlerName, (RBloomFilter<String>)bloomFilter);
        }
        return bloomFilter;
    }
}

