/*
 * Decompiled with CFR 0.152.
 */
package cn.wanghaomiao.seimi.http.okhttp;

import cn.wanghaomiao.seimi.core.SeimiDownloader;
import cn.wanghaomiao.seimi.http.SeimiCookie;
import cn.wanghaomiao.seimi.http.SeimiHttpType;
import cn.wanghaomiao.seimi.http.okhttp.OkHttpClientBuilderProvider;
import cn.wanghaomiao.seimi.http.okhttp.OkHttpRequestGenerator;
import cn.wanghaomiao.seimi.struct.BodyType;
import cn.wanghaomiao.seimi.struct.CrawlerModel;
import cn.wanghaomiao.seimi.struct.Request;
import cn.wanghaomiao.seimi.utils.StrFormatUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.StringUtils;
import org.seimicrawler.xpath.JXDocument;
import org.seimicrawler.xpath.exception.XpathSyntaxErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpDownloader
implements SeimiDownloader {
    private CrawlerModel crawlerModel;
    private Request currentRequest;
    private Request.Builder currentRequestBuilder;
    private OkHttpClient okHttpClient;
    private Response lastResponse;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public OkHttpDownloader(CrawlerModel crawlerModel) {
        this.crawlerModel = crawlerModel;
    }

    @Override
    public cn.wanghaomiao.seimi.struct.Response process(Request request) throws Exception {
        this.currentRequest = request;
        OkHttpClient.Builder hcBuilder = OkHttpClientBuilderProvider.getInstance();
        if (this.crawlerModel.isUseCookie()) {
            hcBuilder.cookieJar((CookieJar)this.crawlerModel.getOkHttpCookiesManager());
            this.addCookies(request.getUrl(), request.getSeimiCookies());
        }
        if (this.crawlerModel.getStdProxy() != null) {
            hcBuilder.proxy(this.crawlerModel.getStdProxy());
        }
        hcBuilder.readTimeout((long)this.crawlerModel.getHttpTimeOut(), TimeUnit.MILLISECONDS);
        hcBuilder.connectTimeout((long)this.crawlerModel.getHttpTimeOut(), TimeUnit.MILLISECONDS);
        this.okHttpClient = hcBuilder.build();
        this.currentRequestBuilder = OkHttpRequestGenerator.getOkHttpRequesBuilder(request, this.crawlerModel);
        this.lastResponse = this.okHttpClient.newCall(this.currentRequestBuilder.build()).execute();
        return this.renderResponse(this.lastResponse, request);
    }

    @Override
    public cn.wanghaomiao.seimi.struct.Response metaRefresh(String nextUrl) throws Exception {
        HttpUrl lastUrl = this.lastResponse.request().url();
        if (!nextUrl.startsWith("http")) {
            String prefix = lastUrl.scheme() + "://" + lastUrl.host() + lastUrl.encodedPath();
            nextUrl = prefix + nextUrl;
        }
        this.logger.info("Seimi refresh url to={} from={}", (Object)nextUrl, (Object)lastUrl.toString());
        this.currentRequestBuilder.url(nextUrl);
        this.lastResponse = this.okHttpClient.newCall(this.currentRequestBuilder.build()).execute();
        return this.renderResponse(this.lastResponse, this.currentRequest);
    }

    @Override
    public int statusCode() {
        return this.lastResponse.code();
    }

    @Override
    public void addCookies(String url, List<SeimiCookie> seimiCookies) {
        if (seimiCookies == null || seimiCookies.size() <= 0) {
            return;
        }
        for (SeimiCookie seimiCookie : seimiCookies) {
            Cookie.Builder cookieBuilder = new Cookie.Builder();
            cookieBuilder.name(seimiCookie.getName()).value(seimiCookie.getValue()).path(StringUtils.isNotBlank((CharSequence)seimiCookie.getPath()) ? seimiCookie.getPath() : "/").domain(StringUtils.isNotBlank((CharSequence)seimiCookie.getDomain()) ? seimiCookie.getDomain() : StrFormatUtil.getDodmain(url));
            try {
                this.crawlerModel.getOkHttpCookiesManager().addCookie(new URI(url), cookieBuilder.build());
            }
            catch (URISyntaxException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private cn.wanghaomiao.seimi.struct.Response renderResponse(Response hcResponse, Request request) {
        cn.wanghaomiao.seimi.struct.Response seimiResponse;
        block8: {
            seimiResponse = new cn.wanghaomiao.seimi.struct.Response();
            seimiResponse.setSeimiHttpType(SeimiHttpType.OK_HTTP3);
            seimiResponse.setRealUrl(this.lastResponse.request().url().toString());
            seimiResponse.setUrl(request.getUrl());
            seimiResponse.setRequest(request);
            seimiResponse.setMeta(request.getMeta());
            seimiResponse.setReferer(hcResponse.header("Referer"));
            ResponseBody okResponseBody = hcResponse.body();
            if (okResponseBody != null) {
                String type = okResponseBody.contentType().type().toLowerCase();
                String subtype = okResponseBody.contentType().subtype().toLowerCase();
                if (type.contains("text") || type.contains("json") || type.contains("ajax") || subtype.contains("json") || subtype.contains("ajax")) {
                    seimiResponse.setBodyType(BodyType.TEXT);
                    try {
                        byte[] data = okResponseBody.bytes();
                        String utfContent = new String(data, "UTF-8");
                        String charsetFinal = this.renderRealCharset(utfContent);
                        if (charsetFinal.equals("UTF-8")) {
                            seimiResponse.setContent(utfContent);
                            break block8;
                        }
                        seimiResponse.setContent(new String(data, charsetFinal));
                    }
                    catch (Exception e) {
                        this.logger.error("no content data");
                    }
                } else {
                    seimiResponse.setBodyType(BodyType.BINARY);
                    try {
                        seimiResponse.setData(okResponseBody.bytes());
                    }
                    catch (Exception e) {
                        this.logger.error("no content data");
                    }
                }
            }
        }
        return seimiResponse;
    }

    private String renderRealCharset(String content) throws XpathSyntaxErrorException {
        JXDocument doc = JXDocument.create((String)content);
        String charset = StrFormatUtil.getFirstEmStr(doc.sel("//meta[@charset]/@charset"), "").trim();
        if (StringUtils.isBlank((CharSequence)charset)) {
            charset = StrFormatUtil.getFirstEmStr(doc.sel("//meta[@http-equiv='charset']/@content"), "").trim();
        }
        if (StringUtils.isBlank((CharSequence)charset)) {
            String ct = StringUtils.join((Iterable)doc.sel("//meta[@http-equiv='Content-Type']/@content|//meta[@http-equiv='content-type']/@content"), (String)";").trim();
            charset = StrFormatUtil.parseCharset(ct.toLowerCase());
        }
        return StringUtils.isNotBlank((CharSequence)charset) ? charset : "UTF-8";
    }
}

