/*
 * Decompiled with CFR 0.152.
 */
package cn.wanghaomiao.seimi.struct;

import cn.wanghaomiao.seimi.annotation.Crawler;
import cn.wanghaomiao.seimi.core.SeimiQueue;
import cn.wanghaomiao.seimi.def.BaseSeimiCrawler;
import cn.wanghaomiao.seimi.http.HttpMethod;
import cn.wanghaomiao.seimi.http.SeimiHttpType;
import cn.wanghaomiao.seimi.http.okhttp.CookiesManager;
import cn.wanghaomiao.seimi.struct.Request;
import cn.wanghaomiao.seimi.utils.GenericUtils;
import cn.wanghaomiao.seimi.utils.StrFormatUtil;
import com.alibaba.fastjson.JSON;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.client.CookieStore;
import org.apache.http.impl.client.BasicCookieStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;

public class CrawlerModel {
    private ApplicationContext context;
    private BaseSeimiCrawler instance;
    private Class<? extends BaseSeimiCrawler> clazz;
    private SeimiQueue queueInstance;
    private Class<? extends SeimiQueue> queueClass;
    private Map<String, Method> memberMethods;
    private Map<Integer, String> referenceToMethod = new HashMap<Integer, String>();
    private String crawlerName;
    private HttpHost proxy;
    private boolean useCookie = false;
    private String currentUA;
    private boolean useUnrepeated = true;
    private int delay = 0;
    private SeimiHttpType seimiHttpType;
    private int httpTimeOut;
    private CookieStore aphcCookieStore = new BasicCookieStore();
    private CookiesManager okHttpCookiesManager = new CookiesManager();
    private Logger logger = LoggerFactory.getLogger(CrawlerModel.class);

    public CrawlerModel(Class<? extends BaseSeimiCrawler> cls, ApplicationContext applicationContext) {
        this.context = applicationContext;
        this.clazz = cls;
        this.instance = (BaseSeimiCrawler)this.context.getBean(cls);
        this.init();
    }

    private void init() {
        Crawler c = this.clazz.getAnnotation(Crawler.class);
        Assert.notNull((Object)c, (String)StrFormatUtil.info("crawler {} lost annotation @cn.wanghaomiao.seimi.annotation.Crawler!", this.clazz.getName()));
        this.queueClass = c.queue();
        this.queueInstance = (SeimiQueue)this.context.getBean(this.queueClass);
        Assert.notNull((Object)this.queueInstance, (String)StrFormatUtil.info("can not get {} instance,please check scan path", this.queueClass));
        this.memberMethods = new HashMap<String, Method>();
        ReflectionUtils.doWithMethods(this.clazz, method -> this.memberMethods.put(method.getName(), method));
        this.crawlerName = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{c.name()}) ? c.name() : this.clazz.getSimpleName();
        this.instance.setCrawlerName(this.crawlerName);
        this.resolveProxy(c.proxy());
        this.useCookie = c.useCookie();
        this.currentUA = this.instance.getUserAgent();
        this.delay = c.delay();
        this.useUnrepeated = c.useUnrepeated();
        this.seimiHttpType = c.httpType();
        this.httpTimeOut = c.httpTimeOut();
        this.logger.info("Crawler[{}] init complete.", (Object)this.crawlerName);
    }

    private HttpHost resolveProxy(String proxyStr) {
        HttpHost r = null;
        if (StringUtils.isBlank((CharSequence)proxyStr)) {
            return null;
        }
        if (proxyStr.matches("(http|https|socket)://([0-9a-zA-Z]+\\.?)+:\\d+")) {
            String[] pies = proxyStr.split(":");
            String scheme = pies[0];
            int port = Integer.parseInt(pies[2]);
            String host = pies[1].substring(2);
            r = scheme.equals("socket") ? new HttpHost(host, port) : new HttpHost(host, port, scheme);
        } else {
            this.logger.error("proxy must like \u2018http|https|socket://host:port\u2019");
        }
        this.proxy = r;
        return r;
    }

    private Proxy getStdProxy(String proxyStr) {
        Proxy proxy = null;
        if (StringUtils.isBlank((CharSequence)proxyStr)) {
            return null;
        }
        if (proxyStr.matches("(http|https|socket)://([0-9a-zA-Z]+\\.?)+:\\d+")) {
            String[] pies = proxyStr.split(":");
            String scheme = pies[0];
            int port = Integer.parseInt(pies[2]);
            String host = pies[1].substring(2);
            proxy = scheme.equals("socket") ? new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(host, port)) : new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
        } else {
            this.logger.error("proxy must like \u2018http|https|socket://host:port\u2019");
        }
        return proxy;
    }

    public ApplicationContext getContext() {
        return this.context;
    }

    public BaseSeimiCrawler getInstance() {
        return this.instance;
    }

    public Class<? extends BaseSeimiCrawler> getClazz() {
        return this.clazz;
    }

    public Class<? extends SeimiQueue> getqueueClass() {
        return this.queueClass;
    }

    public Map<String, Method> getMemberMethods() {
        return this.memberMethods;
    }

    public String getCrawlerName() {
        return this.crawlerName;
    }

    public HttpHost getProxy() {
        if (StringUtils.isNotBlank((CharSequence)this.instance.proxy())) {
            return this.resolveProxy(this.instance.proxy());
        }
        return this.proxy;
    }

    public Proxy getStdProxy() {
        if (StringUtils.isNotBlank((CharSequence)this.instance.proxy())) {
            return this.getStdProxy(this.instance.proxy());
        }
        return null;
    }

    public boolean isUseCookie() {
        return this.useCookie;
    }

    public int getDelay() {
        return this.delay;
    }

    public boolean isUseUnrepeated() {
        return this.useUnrepeated;
    }

    public String getCurrentUA() {
        return this.currentUA;
    }

    public SeimiHttpType getSeimiHttpType() {
        return this.seimiHttpType;
    }

    public int getHttpTimeOut() {
        return this.httpTimeOut;
    }

    public CookieStore getCookieStore() {
        return this.aphcCookieStore;
    }

    public CookiesManager getOkHttpCookiesManager() {
        return this.okHttpCookiesManager;
    }

    public SeimiQueue getQueueInstance() {
        return this.queueInstance;
    }

    public void startRequest() {
        Object[] startUrls = this.instance.startUrls();
        boolean trigger = false;
        if (ArrayUtils.isNotEmpty((Object[])startUrls)) {
            for (Object url : startUrls) {
                Request request = new Request();
                String[] urlPies = ((String)url).split("##");
                if (urlPies.length >= 2 && StringUtils.lowerCase((String)urlPies[1]).equals("post")) {
                    request.setHttpMethod(HttpMethod.POST);
                }
                request.setCrawlerName(this.crawlerName);
                request.setUrl((String)url);
                request.setCallBack("start");
                this.queueInstance.push(request);
                this.logger.info("{} url={} started", (Object)this.crawlerName, url);
            }
            trigger = true;
        }
        if (!CollectionUtils.isEmpty(this.instance.startRequests())) {
            for (Request request : this.instance.startRequests()) {
                request.setCrawlerName(this.crawlerName);
                if (StringUtils.isBlank((CharSequence)request.getCallBack())) {
                    request.setCallBack("start");
                }
                this.queueInstance.push(request);
                this.logger.info("{} url={} started", (Object)this.crawlerName, (Object)request.getUrl());
            }
            trigger = true;
        }
        if (!trigger) {
            this.logger.error("crawler:{} can not find start urls!", (Object)this.crawlerName);
        }
    }

    public void sendRequest(Request request) {
        request.setCrawlerName(this.crawlerName);
        if (!this.checkRequest(request)) {
            return;
        }
        if (request.isLambdaCb()) {
            request.setCallBack(this.getMethodName(request.getCallBackFunc()));
        }
        this.queueInstance.push(request);
        this.queueInstance.addProcessed(request);
    }

    public boolean checkRequest(Request request) {
        if (!request.isSkipDuplicateFilter() && this.isUseUnrepeated() && this.queueInstance.isProcessed(request) && request.getCurrentReqCount() == 0) {
            this.logger.debug("This request has bean processed,so current request={} will be dropped!", (Object)JSON.toJSONString((Object)request));
            return false;
        }
        return true;
    }

    public String queueInfo() {
        HashMap<String, Long> data = new HashMap<String, Long>();
        data.put("currentLen", this.queueInstance.len(this.getCrawlerName()));
        data.put("total", this.queueInstance.totalCrawled(this.getCrawlerName()));
        return JSON.toJSONString(data);
    }

    public String getMethodName(Request.SeimiCallbackFunc methodRef) {
        String methodName = this.referenceToMethod.get(methodRef.hashCode());
        if (StringUtils.isNotBlank((CharSequence)methodName)) {
            return methodName;
        }
        Method method = GenericUtils.getReferencedMethod(this.clazz, methodRef);
        methodName = method.getName();
        this.referenceToMethod.put(methodRef.hashCode(), methodName);
        return methodName;
    }
}

