/*
 * Decompiled with CFR 0.152.
 */
package cn.wanghaomiao.seimi.struct;

import cn.wanghaomiao.seimi.annotation.validate.NotNull;
import cn.wanghaomiao.seimi.core.SeimiCrawler;
import cn.wanghaomiao.seimi.http.HttpMethod;
import cn.wanghaomiao.seimi.http.SeimiAgentContentType;
import cn.wanghaomiao.seimi.http.SeimiCookie;
import cn.wanghaomiao.seimi.struct.CommonObject;
import cn.wanghaomiao.seimi.struct.Response;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Request
extends CommonObject {
    @NotNull
    private String crawlerName;
    @NotNull
    private String url;
    private HttpMethod httpMethod;
    private Map<String, String> params;
    private Map<String, Object> meta;
    @NotNull
    private String callBack;
    private transient boolean lambdaCb = false;
    private transient SeimiCallbackFunc callBackFunc;
    private boolean stop = false;
    private int maxReqCount = 3;
    private int currentReqCount = 0;
    private boolean skipDuplicateFilter = false;
    private boolean useSeimiAgent = false;
    private Map<String, String> header;
    private long seimiAgentRenderTime = 0L;
    private String seimiAgentScript;
    private Boolean seimiAgentUseCookie;
    private SeimiAgentContentType seimiAgentContentType = SeimiAgentContentType.HTML;
    private List<SeimiCookie> seimiCookies;

    public <T, A1> Request(String url, String callBack, SeimiCallbackFunc<T, A1> cbFunc, HttpMethod httpMethod, Map<String, String> params, Map<String, Object> meta, int maxReqCount) {
        this.url = url;
        this.httpMethod = httpMethod;
        this.params = params;
        this.meta = meta;
        this.callBack = callBack;
        this.maxReqCount = maxReqCount;
        this.callBackFunc = cbFunc;
        if (this.callBackFunc != null) {
            this.lambdaCb = true;
        }
    }

    public Request(String url, String callBack) {
        this.url = url;
        this.callBack = callBack;
    }

    public <T, A1> Request(String url, SeimiCallbackFunc<T, A1> callBackFunc) {
        this.url = url;
        this.callBackFunc = callBackFunc;
        this.lambdaCb = true;
    }

    public static <T, A1> Request build(String url, String callBack, SeimiCallbackFunc<T, A1> callBackFunc, HttpMethod httpMethod, Map<String, String> params, Map<String, Object> meta, int maxReqcount) {
        return new Request(url, callBack, callBackFunc, httpMethod, params, meta, maxReqcount);
    }

    public static Request build(String url, String callBack, HttpMethod httpMethod, Map<String, String> params, Map<String, Object> meta) {
        return new Request(url, callBack, null, httpMethod, params, meta, 1);
    }

    public static Request build(String url, String callBack) {
        return new Request(url, callBack, null, null, null, null, 1);
    }

    public static <T, A1> Request build(String url, SeimiCallbackFunc<T, A1> callBackFunc) {
        return new Request(url, null, callBackFunc, null, null, null, 1);
    }

    public static Request build(String url, String callBack, int maxReqCount) {
        return new Request(url, callBack, null, null, null, null, maxReqCount);
    }

    public Request() {
    }

    public void incrReqCount() {
        ++this.currentReqCount;
    }

    public String getUrl() {
        return this.url;
    }

    public Request setUrl(String url) {
        this.url = url;
        return this;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public Request setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public Request setParams(Map<String, String> params) {
        this.params = params;
        return this;
    }

    public Map<String, Object> getMeta() {
        if (this.meta == null) {
            this.meta = new HashMap<String, Object>();
        }
        return this.meta;
    }

    public Request setMeta(Map<String, Object> meta) {
        this.meta = meta;
        return this;
    }

    public String getCallBack() {
        return this.callBack;
    }

    public Request setCallBack(String callBack) {
        this.callBack = callBack;
        return this;
    }

    public Request setCallBack(SeimiCallbackFunc<SeimiCrawler, Response> cbFunc) {
        this.callBackFunc = cbFunc;
        this.lambdaCb = true;
        return this;
    }

    public boolean isStop() {
        return this.stop;
    }

    public Request setStop(boolean stop) {
        this.stop = stop;
        return this;
    }

    public int getMaxReqCount() {
        return this.maxReqCount;
    }

    public Request setMaxReqCount(int maxReqCount) {
        this.maxReqCount = maxReqCount;
        return this;
    }

    public int getCurrentReqCount() {
        return this.currentReqCount;
    }

    public Request setCurrentReqCount(int currentReqCount) {
        this.currentReqCount = currentReqCount;
        return this;
    }

    public boolean isSkipDuplicateFilter() {
        return this.skipDuplicateFilter;
    }

    public Request setSkipDuplicateFilter(boolean skipDuplicateFilter) {
        this.skipDuplicateFilter = skipDuplicateFilter;
        return this;
    }

    public String getCrawlerName() {
        return this.crawlerName;
    }

    public Request setCrawlerName(String crawlerName) {
        this.crawlerName = crawlerName;
        return this;
    }

    public Request useSeimiAgent() {
        this.useSeimiAgent = true;
        return this;
    }

    public Request setUseSeimiAgent(boolean useSeimiAgent) {
        this.useSeimiAgent = useSeimiAgent;
        return this;
    }

    public boolean isUseSeimiAgent() {
        return this.useSeimiAgent;
    }

    public long getSeimiAgentRenderTime() {
        return this.seimiAgentRenderTime;
    }

    public Request setSeimiAgentRenderTime(long seimiAgentRenderTime) {
        this.seimiAgentRenderTime = seimiAgentRenderTime;
        return this;
    }

    public String getSeimiAgentScript() {
        return this.seimiAgentScript;
    }

    public Request setSeimiAgentScript(String seimiAgentScript) {
        this.seimiAgentScript = seimiAgentScript;
        return this;
    }

    public Boolean isSeimiAgentUseCookie() {
        return this.seimiAgentUseCookie;
    }

    public Request setSeimiAgentUseCookie(Boolean seimiAgentUseCookie) {
        this.seimiAgentUseCookie = seimiAgentUseCookie;
        return this;
    }

    public SeimiAgentContentType getSeimiAgentContentType() {
        return this.seimiAgentContentType;
    }

    public Request setSeimiAgentContentType(SeimiAgentContentType seimiAgentContentType) {
        this.seimiAgentContentType = seimiAgentContentType;
        return this;
    }

    public Map<String, String> getHeader() {
        return this.header;
    }

    public Request setHeader(Map<String, String> header) {
        this.header = header;
        return this;
    }

    public List<SeimiCookie> getSeimiCookies() {
        return this.seimiCookies;
    }

    public Request setSeimiCookies(List<SeimiCookie> seimiCookies) {
        this.seimiCookies = seimiCookies;
        return this;
    }

    public SeimiCallbackFunc getCallBackFunc() {
        return this.callBackFunc;
    }

    public boolean isLambdaCb() {
        return this.lambdaCb;
    }

    @FunctionalInterface
    public static interface SeimiCallbackFunc<T, A1> {
        public void call(T var1, A1 var2);
    }
}

