/*
 * Decompiled with CFR 0.152.
 */
package cn.wanghaomiao.seimi.utils;

import cn.wanghaomiao.seimi.core.CastToNumber;
import cn.wanghaomiao.seimi.struct.Request;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import org.apache.commons.codec.digest.DigestUtils;

public class GenericUtils {
    private static final Class<?>[] EMPTY_CLASSES = new Class[0];
    private static final Map<Class, CastToNumber> numberClass = new HashMap<Class, CastToNumber>(){
        {
            this.put(Integer.TYPE, ori -> new BigDecimal(ori).intValue());
            this.put(Integer.class, ori -> new BigDecimal(ori).intValue());
            this.put(Long.TYPE, ori -> new BigDecimal(ori).longValue());
            this.put(Long.class, ori -> new BigDecimal(ori).longValue());
            this.put(Short.TYPE, ori -> new BigDecimal(ori).shortValue());
            this.put(Short.class, ori -> new BigDecimal(ori).shortValue());
            this.put(Float.TYPE, ori -> Float.valueOf(new BigDecimal(ori).floatValue()));
            this.put(Float.class, ori -> Float.valueOf(new BigDecimal(ori).floatValue()));
            this.put(Double.TYPE, ori -> new BigDecimal(ori).doubleValue());
            this.put(Double.class, ori -> new BigDecimal(ori).doubleValue());
        }
    };

    public static Class<?>[] getActualClass(Type genericType) {
        if (genericType instanceof ParameterizedType) {
            Type[] actualTypes = ((ParameterizedType)genericType).getActualTypeArguments();
            Class[] actualClasses = new Class[actualTypes.length];
            for (int i = 0; i < actualTypes.length; ++i) {
                Type actualType = actualTypes[i];
                if (actualType instanceof Class) {
                    actualClasses[i] = (Class)actualType;
                    continue;
                }
                if (!(actualType instanceof GenericArrayType)) continue;
                Type componentType = ((GenericArrayType)actualType).getGenericComponentType();
                actualClasses[i] = Array.newInstance((Class)componentType, 0).getClass();
            }
            return actualClasses;
        }
        return EMPTY_CLASSES;
    }

    public static boolean isNumber(Class cls) {
        return numberClass.containsKey(cls);
    }

    public static Object castToNumber(Class cls, String val) {
        return numberClass.get(cls).castTo(val);
    }

    public static String sortParams(Map<String, String> params) {
        if (params == null) {
            return "";
        }
        JSONObject data = new JSONObject(new LinkedHashMap());
        LinkedList<String> keys = new LinkedList<String>(params.keySet());
        Collections.sort(keys);
        for (String k : keys) {
            data.put(k, (Object)params.get(k));
        }
        return data.toJSONString();
    }

    public static String signRequest(Request request) {
        return DigestUtils.md5Hex((String)(request.getUrl() + GenericUtils.sortParams(request.getParams())));
    }

    public static <T, A1> Method getReferencedMethod(Class<T> clazz, Request.SeimiCallbackFunc<T, A1> methodRef) {
        return GenericUtils.findReferencedMethod(clazz, t -> methodRef.call(t, null));
    }

    private static <T> Method findReferencedMethod(Class<T> clazz, Consumer<T> invoker) {
        AtomicReference ref = new AtomicReference();
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(clazz);
        enhancer.setCallback((Callback)((MethodInterceptor)(obj, method, args, proxy) -> {
            ref.set(method);
            return null;
        }));
        try {
            invoker.accept(enhancer.create());
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(String.format("Invalid method reference on class [%s]", clazz));
        }
        Method method2 = (Method)ref.get();
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Invalid method reference on class [%s]", clazz));
        }
        return method2;
    }
}

