package cn.wangzq.flog.service;

import android.text.TextUtils;
import android.util.Log;

import java.util.Properties;

import cn.wangzq.flog.ILog;
import cn.wangzq.flog.Level;


public class ConsoleLog implements ILog {

    public ConsoleLog() {
    }

    public static final String TYPE = "console";

    private static final String KEY_TAG = TYPE + ".tag";
    private static final String KEY_LOG_LEVEL = TYPE + ".level";

    private String mTag = null;
    private int mLevel = Level.VERBOSE;

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void load(Properties p) {
        this.mTag = p.getProperty(KEY_TAG, this.mTag);
        this.mLevel = Level.parse(p.getProperty(KEY_LOG_LEVEL, "V"));
    }

    private String getTag(String tag) {
        if (TextUtils.isEmpty(mTag)) {
            return tag;
        }
        return mTag;
    }

    private String getMsg(String tag, String msg) {
        StackTraceElement[] stack = new Throwable().getStackTrace();
        String sourceInfo = stack[3].getFileName() + ":" + stack[3].getLineNumber();
        if (!TextUtils.isEmpty(mTag)) {
            msg = tag + ": " + msg;
        }
        return msg + " (" + sourceInfo + ")";
    }

    @Override
    public void v(String tag, String msg) {
        Log.v(this.getTag(tag), getMsg(tag, msg));
    }

    @Override
    public void v(String tag, String msg, Throwable e) {
        Log.v(this.getTag(tag), getMsg(tag, msg), e);
    }

    @Override
    public void d(String tag, String msg) {
        Log.d(this.getTag(tag), getMsg(tag, msg));
    }

    @Override
    public void i(String tag, String msg) {
        Log.i(this.getTag(tag), getMsg(tag, msg));
    }

    @Override
    public void w(String tag, String msg) {
        Log.w(this.getTag(tag), getMsg(tag, msg));
    }

    @Override
    public void w(String tag, Throwable throwable) {
        Log.w(this.getTag(tag), throwable);
    }

    @Override
    public void w(String tag, String msg, Throwable throwable) {
        Log.w(this.getTag(tag), getMsg(tag, msg), throwable);
    }

    @Override
    public void e(String tag, String msg) {
        Log.e(this.getTag(tag), getMsg(tag, msg));
    }

    @Override
    public void e(String tag, String msg, Throwable throwable) {
        Log.e(this.getTag(tag), getMsg(tag, msg), throwable);
    }

    @Override
    public boolean isEnable(int level) {
        return level >= mLevel;
    }
}
