package cn.wangzq.flog;

final public class Level {
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    public static final int NONE = 999;


    public static int parse(String level) {

        int res = VERBOSE;
        level = level.toUpperCase();
        switch (level) {
            case "V":
            case "VERBOSE":
                res = VERBOSE;
                break;
            case "D":
            case "DEBUG":
                res = DEBUG;
                break;
            case "I":
            case "INFO":
                res = INFO;
                break;
            case "W":
            case "WARN":
                res = WARN;
                break;
            case "E":
            case "ERROR":
                res = ERROR;
                break;
            case "NONE":
                res = NONE;
                break;
        }
        return res;
    }
}
