package cn.wangzq.flog;


import java.util.HashMap;
import java.util.Properties;
import java.util.ServiceLoader;


public class Log {

    private static Properties sConfig = new Properties();

    private static final HashMap<String, ILog> LOG_SERVICE = new HashMap<>();

    private static void init() {
        ServiceLoader<ILog> loader = ServiceLoader.load(ILog.class);
        for (ILog service : loader) {
            addLogService(service);
        }
    }

    public static void init(Properties config) {
        setConfig(config);
        init();
    }

    public static void setConfig(Properties config) {
        if (null == config) return;
        sConfig = config;
        for (ILog log : LOG_SERVICE.values()) {
            log.load(config);
        }
    }

    public static void removeService(String... logType) {
        for (String s : logType) {
            LOG_SERVICE.remove(s);
        }
    }

    public static void addLogService(ILog... service) {
        for (ILog log : service) {
            log.load(sConfig);
            LOG_SERVICE.put(log.getType(), log);
        }
    }

    public static void setLogService(ILog... service) {
        LOG_SERVICE.clear();
        for (ILog log : service) {
            log.load(sConfig);
            LOG_SERVICE.put(log.getType(), log);
        }
    }


    public static void v(String tag, String msg) {
        for (ILog log : LOG_SERVICE.values()) {
            if (log.isEnable(Level.VERBOSE)) {
                log.v(tag, msg);
            }
        }
    }

    public static void v(String tag, String msg, Throwable e) {
        for (ILog log : LOG_SERVICE.values()) {
            if (log.isEnable(Level.VERBOSE)) {
                log.v(tag, msg, e);
            }
        }
    }

    public static void d(String tag, String msg) {
        for (ILog log : LOG_SERVICE.values()) {
            if (log.isEnable(Level.DEBUG)) {
                log.d(tag, msg);
            }
        }
    }

    public static void i(String tag, String msg) {
        for (ILog log : LOG_SERVICE.values()) {
            if (log.isEnable(Level.INFO)) {
                log.i(tag, msg);
            }
        }
    }

    public static void w(String tag, String msg) {
        for (ILog log : LOG_SERVICE.values()) {
            if (log.isEnable(Level.WARN)) {
                log.w(tag, msg);
            }
        }
    }

    public static void w(String tag, Throwable throwable) {
        for (ILog log : LOG_SERVICE.values()) {
            if (log.isEnable(Level.WARN)) {
                log.w(tag, throwable);
            }
        }
    }

    public static void w(String tag, String msg, Throwable throwable) {
        for (ILog log : LOG_SERVICE.values()) {
            if (log.isEnable(Level.WARN)) {
                log.w(tag, msg, throwable);
            }
        }

    }

    public static void e(String tag, String msg) {

        for (ILog log : LOG_SERVICE.values()) {
            if (log.isEnable(Level.ERROR)) {
                log.e(tag, msg);
            }
        }
    }

    public static void e(String tag, String msg, Throwable throwable) {
        for (ILog log : LOG_SERVICE.values()) {
            if (log.isEnable(Level.ERROR)) {
                log.e(tag, msg, throwable);
            }
        }
    }
}