package cn.wangzq.flog;

import android.content.Context;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;

import cn.wangzq.flog.service.ConsoleLog;

public class LogHelper {

    public static void init(Context context) {
        Log.init(getDefaultProperties(context));
    }

    public static void init(String confPath) {
        Properties p = new Properties();
        try (InputStream in = new FileInputStream(confPath)) {
            p.load(in);
        } catch (Exception e) {
            e.printStackTrace();
        }

        Log.init(p);
    }


    public static void init(Context context, Properties properties) {
        Properties p = getDefaultProperties(context);
        if (null != properties) {
            Enumeration<?> keys = properties.propertyNames();
            while (keys.hasMoreElements()) {
                String key = (String) keys.nextElement();
                p.setProperty(key, properties.getProperty(key));
            }
        }
        Log.init(p);
    }

    private static Properties getDefaultProperties(Context context) {
        Properties p = new Properties();
        try (InputStream stream = context.getAssets().open("flog/config.properties")) {
            p.load(stream);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return p;
    }

}
