package cn.webestar.scms.commons;

import lombok.SneakyThrows;

public enum SysCode {

    /**
     * 返回码枚举值
     */
    SUCCESS(10000, "请求成功"),
    ERROR(50000, "服务异常"),
    FORBIDDEN(10401, "无权访问"),
    UNAUTHORIZED(10403, "禁止访问"),
    NOT_FOUND(10404, "资源不存在");

    private final Integer code;
    private final String message;

    SysCode(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    @SneakyThrows
    public static Integer biz(int i){
        if (i < 1 || i > 9999) {
            throw new Exception("i值介于1-9999之间");
        }
        return 20000 + i;
    }

    public Integer getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }

}
