package cn.webestar.scms.commons.api;

import com.baomidou.mybatisplus.core.metadata.IPage;

import java.util.Collections;
import java.util.List;

public class PageVO<T> {

    private Long pageNum = 1L;
    private Long pageSize = 50L;
    private Long totalPage;
    private Long totalCount;

    private List<T> records = Collections.emptyList();

    public PageVO() {}
    public PageVO(IPage<T> page) {
        this(page.getCurrent(), page.getSize(), page.getTotal(), page.getRecords());
    }

    public PageVO(Long pageNum, Long pageSize, Long totalCount, List<T> records) {
        this.pageNum = pageNum;
        this.pageSize = pageSize;
        this.totalCount = totalCount;
        if(this.totalCount>0){
            this.totalPage = (totalCount % pageSize == 0) ? totalCount/pageSize
                    : (totalCount/pageSize) + 1;
        } else {
            this.totalPage = 0L;
        }
        this.records = records;
    }

    public Long getPageSize() {
        return pageSize;
    }

    public void setPageSize(Long pageSize) {
        this.pageSize = pageSize;
    }

    public Long getPageNum() {
        return pageNum;
    }

    public void setPageNum(Long pageNum) {
        this.pageNum = pageNum;
    }

    public Long getTotalCount() {
        return totalCount;
    }

    public void setTotalCount(Long totalCount) {
        this.totalCount = totalCount;
    }

    public List<T> getRecords() {
        return records;
    }

    public void setRecords(List<T> records) {
        this.records = records;
    }

    public Long getTotalPage() {
        return totalPage;
    }

    public void setTotalPage(Long totalPage) {
        this.totalPage = totalPage;
    }
}
