package cn.webestar.scms.commons;

import java.io.Serializable;

public class R<T> implements Serializable {

    private Integer code;
    private T data;
    private String message;

    /**
     * 禁止new，全部使用静态方法
     */
    private R() { }

    private R(Integer code, T data) {
        this.code = code;
        this.data = data;
    }

    private R(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    private R(Integer code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public static R<?> success() {
        return new R<>(SysCode.SUCCESS.getCode(), SysCode.SUCCESS.getMessage());
    }

    public static <T> R<T> success(T data) {
        return new R<>(SysCode.SUCCESS.getCode(), data);
    }

    public static R<?> fail(String message) {
        return new R<>(SysCode.ERROR.getCode(), SysCode.ERROR.getMessage());
    }

    public static R<?> fail(Integer code, String message) {
        return new R<>(code, message);
    }

    public static <T> R<T> fail(Integer code, String message, T data) {
        return new R<>(code, message, data);
    }

    public static <T> R<T> fail(CommonException ex) {
        return new R<>(ex.getCode(), ex.getMessage());
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

}
