package cn.webestar.scms.commons.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
public class CommonDO<T extends Serializable> extends BasicDO<T> {

    /**
     * 创建人
     */
    @TableField(value = "creator", fill = FieldFill.INSERT)
    protected String creator;

    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    @JsonSerialize(using = LocalDateTimeSerializer.class)
    @JsonDeserialize(using = LocalDateTimeDeserializer.class)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    protected LocalDateTime createTime;

    /**
     * 更新人
     */
    @TableField(value = "updater", fill = FieldFill.INSERT_UPDATE)
    protected String updater;

    /**
     * 更新时间PointTaskTypeMapper
     */
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    @JsonSerialize(using = LocalDateTimeSerializer.class)
    @JsonDeserialize(using = LocalDateTimeDeserializer.class)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    protected LocalDateTime updateTime;

//    /**
//     * 是否删除 0:未删除,1:已删除
//     */
//    @TableLogic(value = "false", delval = "true")
//    @TableField(value = "is_deleted")
//    protected Boolean isDeleted;
//
//    /**
//     * 删除人
//     */
//    @TableField(value = "delete_by", fill = FieldFill.UPDATE)
//    protected Long deleteBy;
//
//    /**
//     * 删除时间
//     */
//    @TableField(value = "delete_time", fill = FieldFill.UPDATE)
//    @JsonSerialize(using = LocalDateTimeSerializer.class)
//    @JsonDeserialize(using = LocalDateTimeDeserializer.class)
//    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
//    protected LocalDateTime deleteTime;

}
