package cn.webestar.scms.commons;

/**
 * @author zgs
 */
public class Assert {

    public static void notNull(Object obj) throws CommonException {
        notNull(obj, SysCode.ERROR.getCode(), SysCode.ERROR.getMessage());
    }

    public static void notNull(Object obj, String errorMsg) throws CommonException {
        notNull(obj, SysCode.ERROR.getCode(), errorMsg);
    }

    public static void notNull(Object obj, Integer errorCode, String errorMsg) throws CommonException {
        if(obj==null){
            throwCommonException(errorCode, errorMsg);
        }
    }

    public static void notEmpty(String obj) throws CommonException {
        notEmpty(obj, SysCode.ERROR.getCode(), SysCode.ERROR.getMessage());
    }

    public static void notEmpty(String obj, String errorMsg) throws CommonException {
        notEmpty(obj, SysCode.ERROR.getCode(), errorMsg);
    }

    public static void notEmpty(String obj, Integer errorCode, String errorMsg) throws CommonException {
        if(obj==null || obj.trim().isEmpty()){
            throwCommonException(errorCode, errorMsg);
        }
    }

    public static void isTrue(boolean expression) throws CommonException {
        isTrue(expression, SysCode.ERROR.getCode(), SysCode.ERROR.getMessage());
    }

    public static void isTrue(boolean expression, String errorMsg) throws CommonException {
        isTrue(expression, SysCode.ERROR.getCode(), errorMsg);
    }

    public static void isTrue(boolean expression, Integer errorCode, String errorMsg) throws CommonException {
        if(!expression){
            throwCommonException(errorCode, errorMsg);
        }
    }

    private static void throwCommonException(Integer errorCode, String errorMsg) throws CommonException {
        throw new CommonException(errorCode, errorMsg);
    }

}
